/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.IsAlterTableDoneResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class IsAlterTableDoneRequest
extends KuduRpc<IsAlterTableDoneResponse> {
    static final String IS_ALTER_TABLE_DONE = "IsAlterTableDone";
    private final String name;

    IsAlterTableDoneRequest(KuduTable masterTable, String name) {
        super(masterTable);
        this.name = name;
    }

    @Override
    Message createRequestPB() {
        Master.IsAlterTableDoneRequestPB.Builder builder = Master.IsAlterTableDoneRequestPB.newBuilder();
        Master.TableIdentifierPB tableID = Master.TableIdentifierPB.newBuilder().setTableName(this.name).build();
        builder.setTable(tableID);
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return IS_ALTER_TABLE_DONE;
    }

    @Override
    Pair<IsAlterTableDoneResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Master.IsAlterTableDoneResponsePB.Builder respBuilder = Master.IsAlterTableDoneResponsePB.newBuilder();
        IsAlterTableDoneRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        IsAlterTableDoneResponse resp = new IsAlterTableDoneResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, respBuilder.getDone());
        return new Pair<IsAlterTableDoneResponse, Object>(resp, respBuilder.hasError() ? respBuilder.getError() : null);
    }
}

