/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.BatchResponse;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.Statistics;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.client.shaded.com.google.common.base.MoreObjects;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class Batch
extends KuduRpc<BatchResponse> {
    final List<Operation> operations = new ArrayList<Operation>();
    private final LocatedTablet tablet;
    private long rowOperationsSizeBytes = 0L;
    private final boolean ignoreAllDuplicateRows;
    private static Tserver.TabletServerErrorPB injectedError;
    private static int injectedlatencyMs;

    Batch(KuduTable table, LocatedTablet tablet, boolean ignoreAllDuplicateRows) {
        super(table);
        this.ignoreAllDuplicateRows = ignoreAllDuplicateRows;
        this.tablet = tablet;
    }

    long getRowOperationsSizeBytes() {
        if (this.rowOperationsSizeBytes == 0L) {
            throw new IllegalStateException("This row hasn't been serialized yet");
        }
        return this.rowOperationsSizeBytes;
    }

    public void add(Operation operation) {
        assert (Bytes.memcmp(operation.partitionKey(), this.tablet.getPartition().getPartitionKeyStart()) >= 0 && (this.tablet.getPartition().getPartitionKeyEnd().length == 0 || Bytes.memcmp(operation.partitionKey(), this.tablet.getPartition().getPartitionKeyEnd()) < 0));
        this.operations.add(operation);
    }

    @Override
    Message createRequestPB() {
        Tserver.WriteRequestPB.Builder builder = Operation.createAndFillWriteRequestPB(this.operations);
        this.rowOperationsSizeBytes = builder.getRowOperations().getRows().size() + builder.getRowOperations().getIndirectData().size();
        builder.setTabletId(ZeroCopyLiteralByteString.wrap(this.getTablet().getTabletIdAsBytes()));
        builder.setExternalConsistencyMode(this.externalConsistencyMode.pbVersion());
        return builder.build();
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return "Write";
    }

    @Override
    Pair<BatchResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws KuduException {
        Tserver.WriteResponsePB.Builder builder = Tserver.WriteResponsePB.newBuilder();
        Batch.readProtobuf(callResponse.getPBMessage(), builder);
        List<Tserver.WriteResponsePB.PerRowErrorPB> errorsPB = builder.getPerRowErrorsList();
        if (this.ignoreAllDuplicateRows) {
            boolean allAlreadyPresent = true;
            for (Tserver.WriteResponsePB.PerRowErrorPB errorPB : errorsPB) {
                if (errorPB.getError().getCode() == WireProtocol.AppStatusPB.ErrorCode.ALREADY_PRESENT) continue;
                allAlreadyPresent = false;
                break;
            }
            if (allAlreadyPresent) {
                errorsPB = Collections.emptyList();
            }
        }
        BatchResponse response = new BatchResponse(this.deadlineTracker.getElapsedMillis(), tsUUID, builder.getTimestamp(), errorsPB, this.operations);
        if (injectedError != null) {
            if (injectedlatencyMs > 0) {
                try {
                    Thread.sleep(injectedlatencyMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return new Pair<BatchResponse, Object>(response, injectedError);
        }
        return new Pair<BatchResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    public byte[] partitionKey() {
        return this.tablet.getPartition().getPartitionKeyStart();
    }

    @Override
    boolean isRequestTracked() {
        return true;
    }

    @Override
    void updateStatistics(Statistics statistics, BatchResponse response) {
        String tabletId = this.getTablet().getTabletId();
        String tableName = this.getTable().getName();
        Statistics.TabletStatistics tabletStatistics = statistics.getTabletStatistics(tableName, tabletId);
        if (response == null) {
            tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, this.operations.size());
            tabletStatistics.incrementStatistic(Statistics.Statistic.RPC_ERRORS, 1L);
            return;
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_RPCS, 1L);
        for (OperationResponse opResponse : response.getIndividualResponses()) {
            if (opResponse.hasRowError()) {
                tabletStatistics.incrementStatistic(Statistics.Statistic.OPS_ERRORS, 1L);
                continue;
            }
            tabletStatistics.incrementStatistic(Statistics.Statistic.WRITE_OPS, 1L);
        }
        tabletStatistics.incrementStatistic(Statistics.Statistic.BYTES_WRITTEN, this.getRowOperationsSizeBytes());
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("operations", this.operations.size()).add("tablet", this.tablet).add("ignoreAllDuplicateRows", this.ignoreAllDuplicateRows).add("rpc", super.toString()).toString();
    }

    @VisibleForTesting
    static void injectTabletServerErrorAndLatency(Tserver.TabletServerErrorPB error, int latencyMs) {
        injectedError = error;
        injectedlatencyMs = latencyMs;
    }
}

