/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kudu.Common;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.AsyncKuduScanner;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.ColumnRangePredicate;
import org.apache.kudu.client.KuduPredicate;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.HybridTimeUtil;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class AbstractKuduScannerBuilder<S extends AbstractKuduScannerBuilder<? super S, T>, T> {
    final AsyncKuduClient client;
    final KuduTable table;
    final Map<String, KuduPredicate> predicates = new HashMap<String, KuduPredicate>();
    AsyncKuduScanner.ReadMode readMode = AsyncKuduScanner.ReadMode.READ_LATEST;
    Common.OrderMode orderMode = Common.OrderMode.UNORDERED;
    int batchSizeBytes = 0x100000;
    long limit = Long.MAX_VALUE;
    boolean prefetching = false;
    boolean cacheBlocks = true;
    long htTimestamp = -1L;
    byte[] lowerBoundPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] upperBoundPrimaryKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] lowerBoundPartitionKey = AsyncKuduClient.EMPTY_ARRAY;
    byte[] upperBoundPartitionKey = AsyncKuduClient.EMPTY_ARRAY;
    List<String> projectedColumnNames = null;
    List<Integer> projectedColumnIndexes = null;
    long scanRequestTimeout;
    ReplicaSelection replicaSelection = ReplicaSelection.LEADER_ONLY;

    AbstractKuduScannerBuilder(AsyncKuduClient client, KuduTable table) {
        this.client = client;
        this.table = table;
        this.scanRequestTimeout = client.getDefaultOperationTimeoutMs();
    }

    public S readMode(AsyncKuduScanner.ReadMode readMode) {
        this.readMode = readMode;
        return (S)this;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    S sortResultsByPrimaryKey() {
        this.orderMode = Common.OrderMode.ORDERED;
        this.readMode = AsyncKuduScanner.ReadMode.READ_AT_SNAPSHOT;
        return (S)this;
    }

    @Deprecated
    public S addColumnRangePredicate(ColumnRangePredicate predicate) {
        return this.addPredicate(predicate.toKuduPredicate());
    }

    @Deprecated
    public S addColumnRangePredicatesRaw(byte[] predicateBytes) {
        for (Tserver.ColumnRangePredicatePB pb : ColumnRangePredicate.fromByteArray(predicateBytes)) {
            this.addPredicate(ColumnRangePredicate.fromPb(pb).toKuduPredicate());
        }
        return (S)this;
    }

    public S addPredicate(KuduPredicate predicate) {
        String columnName = predicate.getColumn().getName();
        KuduPredicate existing = this.predicates.get(columnName);
        if (existing != null) {
            predicate = existing.merge(predicate);
        }
        if (!predicate.getColumn().isNullable() && predicate.getType() == KuduPredicate.PredicateType.IS_NOT_NULL) {
            return (S)this;
        }
        this.predicates.put(columnName, predicate);
        return (S)this;
    }

    public S setProjectedColumnNames(List<String> columnNames) {
        this.projectedColumnIndexes = null;
        this.projectedColumnNames = columnNames != null ? ImmutableList.copyOf(columnNames) : null;
        return (S)this;
    }

    public S setProjectedColumnIndexes(List<Integer> columnIndexes) {
        this.projectedColumnNames = null;
        this.projectedColumnIndexes = columnIndexes != null ? ImmutableList.copyOf(columnIndexes) : null;
        return (S)this;
    }

    public S batchSizeBytes(int batchSizeBytes) {
        this.batchSizeBytes = batchSizeBytes;
        return (S)this;
    }

    public S limit(long limit) {
        this.limit = limit;
        return (S)this;
    }

    public S prefetching(boolean prefetching) {
        this.prefetching = prefetching;
        return (S)this;
    }

    public S cacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return (S)this;
    }

    @InterfaceAudience.Private
    public S snapshotTimestampRaw(long htTimestamp) {
        this.htTimestamp = htTimestamp;
        return (S)this;
    }

    public S snapshotTimestampMicros(long timestamp) {
        this.htTimestamp = HybridTimeUtil.physicalAndLogicalToHTTimestamp(timestamp, 0L);
        return (S)this;
    }

    public S scanRequestTimeout(long scanRequestTimeout) {
        this.scanRequestTimeout = scanRequestTimeout;
        return (S)this;
    }

    public S lowerBound(PartialRow partialRow) {
        return this.lowerBoundRaw(partialRow.encodePrimaryKey());
    }

    @Deprecated
    public S lowerBoundRaw(byte[] startPrimaryKey) {
        if (this.lowerBoundPrimaryKey.length == 0 || Bytes.memcmp(startPrimaryKey, this.lowerBoundPrimaryKey) > 0) {
            this.lowerBoundPrimaryKey = startPrimaryKey;
        }
        return (S)this;
    }

    public S exclusiveUpperBound(PartialRow partialRow) {
        return this.exclusiveUpperBoundRaw(partialRow.encodePrimaryKey());
    }

    @Deprecated
    public S exclusiveUpperBoundRaw(byte[] endPrimaryKey) {
        if (this.upperBoundPrimaryKey.length == 0 || Bytes.memcmp(endPrimaryKey, this.upperBoundPrimaryKey) < 0) {
            this.upperBoundPrimaryKey = endPrimaryKey;
        }
        return (S)this;
    }

    public S replicaSelection(ReplicaSelection replicaSelection) {
        this.replicaSelection = replicaSelection;
        return (S)this;
    }

    S lowerBoundPartitionKeyRaw(byte[] partitionKey) {
        if (Bytes.memcmp(partitionKey, this.lowerBoundPartitionKey) > 0) {
            this.lowerBoundPartitionKey = partitionKey;
        }
        return (S)this;
    }

    S exclusiveUpperBoundPartitionKeyRaw(byte[] partitionKey) {
        if (this.upperBoundPartitionKey.length == 0 || Bytes.memcmp(partitionKey, this.upperBoundPartitionKey) < 0) {
            this.upperBoundPartitionKey = partitionKey;
        }
        return (S)this;
    }

    public abstract T build();
}

