/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.sasl.SaslException;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.GetMasterRegistrationRequest;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.RecoverableException;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.RequestTracker;
import org.apache.kudu.client.RpcTraceFrame;
import org.apache.kudu.client.SecureRpcHelper;
import org.apache.kudu.client.ServerInfo;
import org.apache.kudu.client.Status;
import org.apache.kudu.client.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.kudu.client.shaded.com.google.protobuf.GeneratedMessage;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFutureListener;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelStateEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ExceptionEvent;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.replay.ReplayingDecoder;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.codec.replay.VoidEnum;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout.ReadTimeoutException;
import org.apache.kudu.master.Master;
import org.apache.kudu.rpc.RpcHeader;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class TabletClient
extends ReplayingDecoder<VoidEnum> {
    public static final Logger LOG = LoggerFactory.getLogger(TabletClient.class);
    private ArrayList<KuduRpc<?>> pendingRpcs;
    public static final byte RPC_CURRENT_VERSION = 9;
    private static final byte[] RPC_HEADER = new byte[]{104, 114, 112, 99, 9, 0, 0};
    public static final int CONNECTION_CTX_CALL_ID = -3;
    private final AtomicInteger rpcid = new AtomicInteger(-1);
    private volatile Channel chan;
    private boolean dead = false;
    private final ConcurrentHashMap<Integer, KuduRpc<?>> rpcsInflight = new ConcurrentHashMap();
    private final AsyncKuduClient kuduClient;
    private final long socketReadTimeoutMs;
    private SecureRpcHelper secureRpcHelper;
    private final RequestTracker requestTracker;
    private final ServerInfo serverInfo;
    private volatile boolean gotUncaughtException = false;

    public TabletClient(AsyncKuduClient client, ServerInfo serverInfo) {
        this.kuduClient = client;
        this.socketReadTimeoutMs = client.getDefaultSocketReadTimeoutMs();
        this.requestTracker = client.getRequestTracker();
        this.serverInfo = serverInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <R> void sendRpc(KuduRpc<R> rpc) {
        rpc.addTrace(new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.SEND_TO_SERVER).serverInfo(this.serverInfo).build());
        if (!rpc.deadlineTracker.hasDeadline()) {
            LOG.warn(this.getPeerUuidLoggingString() + " sending an rpc without a timeout " + rpc);
        }
        Pair<ChannelBuffer, Integer> encodedRpcAndId = null;
        if (this.chan != null) {
            if (!rpc.getRequiredFeatures().isEmpty() && !this.secureRpcHelper.getServerFeatures().contains(RpcHeader.RpcFeatureFlag.APPLICATION_FEATURE_FLAGS)) {
                Status statusNotSupported = Status.NotSupported("the server does not support theAPPLICATION_FEATURE_FLAGS RPC feature");
                rpc.errback(new NonRecoverableException(statusNotSupported));
            }
            if ((encodedRpcAndId = this.encode(rpc)) == null) {
                return;
            }
            Channel chan = this.chan;
            if (chan != null) {
                Channels.write(chan, encodedRpcAndId.getFirst());
                return;
            }
        }
        boolean tryAgain = false;
        boolean failRpc = false;
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            if (this.chan != null) {
                tryAgain = true;
            } else if (this.dead) {
                if (encodedRpcAndId == null || this.rpcsInflight.containsKey(encodedRpcAndId.getSecond())) {
                    failRpc = true;
                }
            } else {
                if (this.pendingRpcs == null) {
                    this.pendingRpcs = new ArrayList();
                }
                this.pendingRpcs.add(rpc);
            }
        }
        if (failRpc) {
            Status statusNetworkError = Status.NetworkError(this.getPeerUuidLoggingString() + "Connection reset");
            this.failOrRetryRpc(rpc, new RecoverableException(statusNetworkError));
        } else if (tryAgain) {
            this.sendRpc(rpc);
        }
    }

    private <R> Pair<ChannelBuffer, Integer> encode(KuduRpc<R> rpc) {
        ChannelBuffer payload;
        int rpcid = this.rpcid.incrementAndGet();
        String service = rpc.serviceName();
        String method = rpc.method();
        try {
            RpcHeader.RequestHeader.Builder headerBuilder = RpcHeader.RequestHeader.newBuilder().setCallId(rpcid).addAllRequiredFeatureFlags(rpc.getRequiredFeatures()).setRemoteMethod(RpcHeader.RemoteMethodPB.newBuilder().setServiceName(service).setMethodName(method));
            if (rpc.deadlineTracker.hasDeadline() || this.socketReadTimeoutMs > 0L) {
                long millisBeforeDeadline = Long.MAX_VALUE;
                if (rpc.deadlineTracker.hasDeadline()) {
                    millisBeforeDeadline = rpc.deadlineTracker.getMillisBeforeDeadline();
                }
                long localRpcTimeoutMs = Long.MAX_VALUE;
                if (this.socketReadTimeoutMs > 0L) {
                    localRpcTimeoutMs = this.socketReadTimeoutMs;
                }
                headerBuilder.setTimeoutMillis((int)Math.min(millisBeforeDeadline, localRpcTimeoutMs));
            }
            if (rpc.isRequestTracked()) {
                RpcHeader.RequestIdPB.Builder requestIdBuilder = RpcHeader.RequestIdPB.newBuilder();
                if (rpc.getSequenceId() == -1L) {
                    rpc.setSequenceId(this.requestTracker.newSeqNo());
                }
                requestIdBuilder.setClientId(this.requestTracker.getClientId());
                requestIdBuilder.setSeqNo(rpc.getSequenceId());
                requestIdBuilder.setAttemptNo(rpc.attempt);
                requestIdBuilder.setFirstIncompleteSeqNo(this.requestTracker.firstIncomplete());
                headerBuilder.setRequestId(requestIdBuilder);
            }
            payload = rpc.serialize(headerBuilder.build());
        }
        catch (Exception e) {
            LOG.error("Uncaught exception while serializing RPC: " + rpc, (Throwable)e);
            rpc.errback(e);
            return null;
        }
        KuduRpc<R> oldrpc = this.rpcsInflight.put(rpcid, rpc);
        if (oldrpc != null) {
            String wtf = this.getPeerUuidLoggingString() + "WTF?  There was already an RPC in flight with rpcid=" + rpcid + ": " + oldrpc + ".  This happened when sending out: " + rpc;
            LOG.error(wtf);
            Status statusIllegalState = Status.IllegalState(wtf);
            oldrpc.errback(new NonRecoverableException(statusIllegalState));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + this.chan + " Sending RPC #" + rpcid + ", payload=" + payload);
        }
        payload = this.secureRpcHelper.wrap(payload);
        return new Pair<ChannelBuffer, Integer>(payload, rpcid);
    }

    @VisibleForTesting
    void disconnect() {
        Channel chancopy = this.chan;
        if (chancopy != null && chancopy.isConnected()) {
            Channels.disconnect(chancopy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Deferred<Void> shutdown() {
        Status statusNetworkError = Status.NetworkError(this.getPeerUuidLoggingString() + "Client is shutting down");
        NonRecoverableException exception = new NonRecoverableException(statusNetworkError);
        Object ite = this.rpcsInflight.values().iterator();
        while (ite.hasNext()) {
            ite.next().errback(exception);
            ite.remove();
        }
        ite = this;
        synchronized (ite) {
            if (this.pendingRpcs != null) {
                Iterator<KuduRpc<?>> ite2 = this.pendingRpcs.iterator();
                while (ite2.hasNext()) {
                    ite2.next().errback(exception);
                    ite2.remove();
                }
            }
        }
        Channel chancopy = this.chan;
        if (chancopy == null) {
            return Deferred.fromResult(null);
        }
        if (chancopy.isConnected()) {
            Channels.disconnect(chancopy);
        }
        if (chancopy.isBound()) {
            Channels.unbind(chancopy);
        }
        ChannelFuture future = Channels.close(chancopy);
        final Deferred d = new Deferred();
        if (future.isSuccess()) {
            d.callback(null);
        } else {
            future.addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        d.callback(null);
                        return;
                    }
                    Throwable t = future.getCause();
                    if (t instanceof Exception) {
                        d.callback((Object)t);
                    } else {
                        Status statusIllegalState = Status.IllegalState("Failed to shutdown: " + TabletClient.this);
                        d.callback((Object)new NonRecoverableException(statusIllegalState, t));
                    }
                }
            });
        }
        return d;
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum voidEnum) throws NonRecoverableException {
        KuduRpc<?> removed;
        long start = System.nanoTime();
        int rdx = buf.readerIndex();
        LOG.debug("------------------>> ENTERING DECODE >>------------------");
        try {
            buf = this.secureRpcHelper.handleResponse(buf, chan);
        }
        catch (SaslException e) {
            String message = this.getPeerUuidLoggingString() + "Couldn't complete the SASL handshake";
            LOG.error(message);
            Status statusIOE = Status.IOError(message);
            throw new NonRecoverableException(statusIOE, (Throwable)e);
        }
        if (buf == null) {
            return null;
        }
        CallResponse response = new CallResponse(buf);
        RpcHeader.ResponseHeader header = response.getHeader();
        if (!header.hasCallId()) {
            int size = response.getTotalResponseSize();
            String msg = this.getPeerUuidLoggingString() + "RPC response (size: " + size + ") doesn't have a call ID: " + header;
            LOG.error(msg);
            Status statusIncomplete = Status.Incomplete(msg);
            throw new NonRecoverableException(statusIncomplete);
        }
        int rpcid = header.getCallId();
        KuduRpc<?> rpc = this.rpcsInflight.get(rpcid);
        if (rpc == null) {
            String msg = this.getPeerUuidLoggingString() + "Invalid rpcid: " + rpcid;
            LOG.error(msg);
            Status statusIllegalState = Status.IllegalState(msg);
            throw new NonRecoverableException(statusIllegalState);
        }
        RpcTraceFrame.RpcTraceFrameBuilder traceBuilder = new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.RECEIVE_FROM_SERVER).serverInfo(this.serverInfo);
        Pair<?, Object> decoded = null;
        KuduException exception = null;
        Status retryableHeaderError = Status.OK();
        if (header.hasIsError() && header.getIsError()) {
            RpcHeader.ErrorStatusPB.Builder errorBuilder = RpcHeader.ErrorStatusPB.newBuilder();
            KuduRpc.readProtobuf(response.getPBMessage(), errorBuilder);
            RpcHeader.ErrorStatusPB error = errorBuilder.build();
            if (error.getCode().equals(RpcHeader.ErrorStatusPB.RpcErrorCodePB.ERROR_SERVER_TOO_BUSY)) {
                retryableHeaderError = Status.ServiceUnavailable(error.getMessage());
            } else {
                String message = this.getPeerUuidLoggingString() + "Tablet server sent error " + error.getMessage();
                Status status = Status.RemoteError(message);
                exception = new NonRecoverableException(status);
                LOG.error(message);
            }
        } else {
            try {
                decoded = rpc.deserialize(response, this.serverInfo.getUuid());
            }
            catch (KuduException ex) {
                exception = ex;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + "rpcid=" + rpcid + ", response size=" + (buf.readerIndex() - rdx) + " bytes, " + this.actualReadableBytes() + " readable bytes left, rpc=" + rpc);
        }
        if ((removed = this.rpcsInflight.remove(rpcid)) == null) {
            Status statusIllegalState = Status.IllegalState("RPC not found");
            throw new NonRecoverableException(statusIllegalState);
        }
        if (!retryableHeaderError.ok()) {
            rpc.addTrace(traceBuilder.callStatus(retryableHeaderError).build());
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(retryableHeaderError));
            return null;
        }
        if (decoded != null) {
            GeneratedMessage error;
            if (decoded.getSecond() instanceof Tserver.TabletServerErrorPB) {
                error = (Tserver.TabletServerErrorPB)decoded.getSecond();
                exception = this.dispatchTSErrorOrReturnException(rpc, (Tserver.TabletServerErrorPB)error, traceBuilder);
                if (exception == null) {
                    return null;
                }
                decoded = null;
            } else if (decoded.getSecond() instanceof Master.MasterErrorPB) {
                error = (Master.MasterErrorPB)decoded.getSecond();
                exception = this.dispatchMasterErrorOrReturnException(rpc, (Master.MasterErrorPB)error, traceBuilder);
                if (exception == null) {
                    return null;
                }
                decoded = null;
            }
        }
        try {
            if (decoded != null) {
                assert (!(decoded.getFirst() instanceof Exception));
                if (this.kuduClient.isStatisticsEnabled()) {
                    rpc.updateStatistics(this.kuduClient.getStatistics(), decoded.getFirst());
                }
                rpc.addTrace(traceBuilder.callStatus(Status.OK()).build());
                rpc.callback(decoded.getFirst());
            } else {
                if (this.kuduClient.isStatisticsEnabled()) {
                    rpc.updateStatistics(this.kuduClient.getStatistics(), null);
                }
                rpc.addTrace(traceBuilder.callStatus(exception.getStatus()).build());
                rpc.errback(exception);
            }
        }
        catch (Exception e) {
            LOG.debug(this.getPeerUuidLoggingString() + "Unexpected exception while handling RPC #" + rpcid + ", rpc=" + rpc, (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("------------------<< LEAVING  DECODE <<------------------ time elapsed: " + (System.nanoTime() - start) / 1000L + "us");
        }
        return null;
    }

    private KuduException dispatchTSErrorOrReturnException(KuduRpc rpc, Tserver.TabletServerErrorPB error, RpcTraceFrame.RpcTraceFrameBuilder traceBuilder) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        Status status = Status.fromTabletServerErrorPB(error);
        if (error.getCode() == Tserver.TabletServerErrorPB.Code.TABLET_NOT_FOUND) {
            this.kuduClient.handleTabletNotFound(rpc, new RecoverableException(status), this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE) {
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(status));
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.ILLEGAL_STATE || code == WireProtocol.AppStatusPB.ErrorCode.ABORTED) {
            this.kuduClient.handleNotLeader(rpc, new RecoverableException(status), this);
        } else {
            return new NonRecoverableException(status);
        }
        rpc.addTrace(traceBuilder.callStatus(status).build());
        return null;
    }

    private KuduException dispatchMasterErrorOrReturnException(KuduRpc rpc, Master.MasterErrorPB error, RpcTraceFrame.RpcTraceFrameBuilder traceBuilder) {
        WireProtocol.AppStatusPB.ErrorCode code = error.getStatus().getCode();
        Status status = Status.fromMasterErrorPB(error);
        if (error.getCode() == Master.MasterErrorPB.Code.NOT_THE_LEADER) {
            this.kuduClient.handleNotLeader(rpc, new RecoverableException(status), this);
        } else if (code == WireProtocol.AppStatusPB.ErrorCode.SERVICE_UNAVAILABLE) {
            if (rpc instanceof GetMasterRegistrationRequest) {
                return new RecoverableException(status);
            }
            this.kuduClient.handleRetryableError(rpc, new RecoverableException(status));
        } else {
            return new NonRecoverableException(status);
        }
        rpc.addTrace(traceBuilder.callStatus(status).build());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object decodeLast(ChannelHandlerContext ctx, Channel chan, ChannelBuffer buf, VoidEnum unused) throws NonRecoverableException {
        if (buf.readable()) {
            try {
                Object object = this.decode(ctx, chan, buf, unused);
                return object;
            }
            finally {
                if (buf.readable()) {
                    LOG.error(this.getPeerUuidLoggingString() + "After decoding the last message on " + chan + ", there was still some undecoded bytes in the channel's buffer (which are going to be lost)");
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            return !this.dead;
        }
    }

    static void ensureReadable(ChannelBuffer buf, int nbytes) {
        buf.markReaderIndex();
        buf.skipBytes(nbytes);
        buf.resetReaderIndex();
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel chan = e.getChannel();
        ChannelBuffer header = this.connectionHeaderPreamble();
        header.writerIndex(RPC_HEADER.length);
        Channels.write(chan, header);
        this.secureRpcHelper = new SecureRpcHelper(this);
        this.secureRpcHelper.sendHello(chan);
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.getPeerUuidLoggingString() + e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.chan = null;
        super.channelDisconnected(ctx, e);
        this.cleanup(e.getChannel());
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.chan = null;
        this.cleanup(e.getChannel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(Channel chan) {
        ArrayList rpcs;
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            if (this.dead) {
                return;
            }
            this.dead = true;
            rpcs = this.pendingRpcs == null ? new ArrayList(this.rpcsInflight.size()) : this.pendingRpcs;
            Iterator<KuduRpc<?>> iterator = this.rpcsInflight.values().iterator();
            while (iterator.hasNext()) {
                KuduRpc<?> rpc = iterator.next();
                rpcs.add(rpc);
                iterator.remove();
            }
            this.pendingRpcs = null;
        }
        Status statusNetworkError = Status.NetworkError(this.getPeerUuidLoggingString() + "Connection reset");
        RecoverableException exception = new RecoverableException(statusNetworkError);
        this.failOrRetryRpcs(rpcs, exception);
    }

    private void failOrRetryRpcs(Collection<KuduRpc<?>> rpcs, RecoverableException exception) {
        for (KuduRpc<?> rpc : rpcs) {
            this.failOrRetryRpc(rpc, exception);
        }
    }

    private void failOrRetryRpc(KuduRpc<?> rpc, RecoverableException exception) {
        rpc.addTrace(new RpcTraceFrame.RpcTraceFrameBuilder(rpc.method(), RpcTraceFrame.Action.RECEIVE_FROM_SERVER).serverInfo(this.serverInfo).callStatus(exception.getStatus()).build());
        RemoteTablet tablet = rpc.getTablet();
        if (tablet == null) {
            rpc.errback(exception);
        } else if (this.gotUncaughtException) {
            this.kuduClient.handleTabletNotFound(rpc, exception, this);
        } else {
            this.kuduClient.handleRetryableError(rpc, exception);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        Throwable e = event.getCause();
        Channel c = event.getChannel();
        if (e instanceof RejectedExecutionException) {
            LOG.warn(this.getPeerUuidLoggingString() + "RPC rejected by the executor, ignore this if we're shutting down", e);
        } else if (e instanceof ReadTimeoutException) {
            LOG.debug(this.getPeerUuidLoggingString() + "Encountered a read timeout, will close the channel");
        } else {
            LOG.error(this.getPeerUuidLoggingString() + "Unexpected exception from downstream on " + c, e);
            this.gotUncaughtException = true;
        }
        if (c.isOpen()) {
            Channels.close(c);
        } else {
            this.cleanup(c);
        }
    }

    private ChannelBuffer connectionHeaderPreamble() {
        return ChannelBuffers.wrappedBuffer(RPC_HEADER);
    }

    public void becomeReady(Channel chan) {
        this.chan = chan;
        this.sendQueuedRpcs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQueuedRpcs() {
        ArrayList<KuduRpc<?>> rpcs;
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            rpcs = this.pendingRpcs;
            this.pendingRpcs = null;
        }
        if (rpcs != null) {
            for (KuduRpc kuduRpc : rpcs) {
                LOG.debug(this.getPeerUuidLoggingString() + "Executing RPC queued: " + kuduRpc);
                this.sendRpc(kuduRpc);
            }
        }
    }

    void sendContext(Channel channel) {
        Channels.write(channel, this.header());
        this.becomeReady(channel);
    }

    private ChannelBuffer header() {
        RpcHeader.ConnectionContextPB.Builder builder = RpcHeader.ConnectionContextPB.newBuilder();
        RpcHeader.UserInformationPB.Builder userBuilder = RpcHeader.UserInformationPB.newBuilder();
        userBuilder.setEffectiveUser("java_client");
        userBuilder.setRealUser("java_client");
        builder.setDEPRECATEDUserInfo(userBuilder.build());
        RpcHeader.ConnectionContextPB pb = builder.build();
        RpcHeader.RequestHeader header = RpcHeader.RequestHeader.newBuilder().setCallId(-3).build();
        return KuduRpc.toChannelBuffer(header, pb);
    }

    private String getPeerUuidLoggingString() {
        return "[Peer " + this.serverInfo.getUuid() + "] ";
    }

    ServerInfo getServerInfo() {
        return this.serverInfo;
    }

    Subject getSubject() {
        return this.kuduClient.getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int npendingRpcs;
        StringBuilder buf = new StringBuilder(169);
        buf.append("TabletClient@").append(this.hashCode()).append("(chan=").append(this.chan).append(", uuid=").append(this.serverInfo.getUuid()).append(", #pending_rpcs=");
        TabletClient tabletClient = this;
        synchronized (tabletClient) {
            npendingRpcs = this.pendingRpcs == null ? 0 : this.pendingRpcs.size();
        }
        buf.append(npendingRpcs);
        buf.append(", #rpcs_inflight=").append(this.rpcsInflight.size()).append(')');
        return buf.toString();
    }
}

