/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Deferred;
import java.util.List;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.AsyncKuduSession;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.OperationResponse;
import org.apache.kudu.client.PleaseThrottleException;
import org.apache.kudu.client.RowErrorsAndOverflowStatus;
import org.apache.kudu.client.SessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduSession
implements SessionConfiguration {
    public static final Logger LOG = LoggerFactory.getLogger(KuduSession.class);
    private final AsyncKuduSession session;

    KuduSession(AsyncKuduSession session) {
        this.session = session;
    }

    public OperationResponse apply(Operation operation) throws KuduException {
        while (true) {
            try {
                Deferred<OperationResponse> d = this.session.apply(operation);
                if (this.getFlushMode() == SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC) {
                    return (OperationResponse)d.join();
                }
            }
            catch (PleaseThrottleException ex) {
                try {
                    ex.getDeferred().join();
                }
                catch (Exception e) {
                    LOG.error("Previous batch had this exception", (Throwable)e);
                }
                continue;
            }
            catch (Exception e) {
                throw KuduException.transformException(e);
            }
            break;
        }
        return null;
    }

    public List<OperationResponse> flush() throws KuduException {
        return KuduClient.joinAndHandleException(this.session.flush());
    }

    public List<OperationResponse> close() throws KuduException {
        return KuduClient.joinAndHandleException(this.session.close());
    }

    @Override
    public SessionConfiguration.FlushMode getFlushMode() {
        return this.session.getFlushMode();
    }

    @Override
    public void setFlushMode(SessionConfiguration.FlushMode flushMode) {
        this.session.setFlushMode(flushMode);
    }

    @Override
    public void setMutationBufferSpace(int size) {
        this.session.setMutationBufferSpace(size);
    }

    @Override
    public void setMutationBufferLowWatermark(float mutationBufferLowWatermarkPercentage) {
        this.session.setMutationBufferLowWatermark(mutationBufferLowWatermarkPercentage);
    }

    @Override
    public void setFlushInterval(int interval) {
        this.session.setFlushInterval(interval);
    }

    @Override
    public long getTimeoutMillis() {
        return this.session.getTimeoutMillis();
    }

    @Override
    public void setTimeoutMillis(long timeout) {
        this.session.setTimeoutMillis(timeout);
    }

    @Override
    public boolean isClosed() {
        return this.session.isClosed();
    }

    @Override
    public boolean hasPendingOperations() {
        return this.session.hasPendingOperations();
    }

    @Override
    public void setExternalConsistencyMode(ExternalConsistencyMode consistencyMode) {
        this.session.setExternalConsistencyMode(consistencyMode);
    }

    @Override
    public boolean isIgnoreAllDuplicateRows() {
        return this.session.isIgnoreAllDuplicateRows();
    }

    @Override
    public void setIgnoreAllDuplicateRows(boolean ignoreAllDuplicateRows) {
        this.session.setIgnoreAllDuplicateRows(ignoreAllDuplicateRows);
    }

    @Override
    public int countPendingErrors() {
        return this.session.countPendingErrors();
    }

    @Override
    public RowErrorsAndOverflowStatus getPendingErrors() {
        return this.session.getPendingErrors();
    }
}

