/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.NoSuchElementException;
import org.apache.kudu.Schema;
import org.apache.kudu.WireProtocol;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.ColumnarRowResult;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.apache.kudu.util.Slice;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ColumnarRowResultIterator
extends RowResultIterator {
    private static final ColumnarRowResultIterator EMPTY = new ColumnarRowResultIterator(0L, null, null, 0, null, null, null, false);
    private final Slice[] data;
    private final Slice[] varlenData;
    private final Slice[] nonNullBitmaps;
    private final RowResult sharedRowResult;

    ColumnarRowResultIterator(long elapsedMillis, String tsUUID, Schema schema, int numRows, Slice[] data, Slice[] varlenData, Slice[] nonNullBitmaps, boolean reuseRowResult) {
        super(elapsedMillis, tsUUID, schema, numRows);
        this.data = data;
        this.varlenData = varlenData;
        this.nonNullBitmaps = nonNullBitmaps;
        this.sharedRowResult = reuseRowResult && numRows != 0 ? new ColumnarRowResult(this.schema, data, varlenData, nonNullBitmaps, -1) : null;
    }

    static ColumnarRowResultIterator makeRowResultIterator(long elapsedMillis, String tsUUID, Schema schema, WireProtocol.ColumnarRowBlockPB data, CallResponse callResponse, boolean reuseRowResult) {
        if (data == null || data.getNumRows() == 0L) {
            return new ColumnarRowResultIterator(elapsedMillis, tsUUID, schema, 0, null, null, null, reuseRowResult);
        }
        Slice[] dataSlices = new Slice[data.getColumnsCount()];
        Slice[] varlenDataSlices = new Slice[data.getColumnsCount()];
        Slice[] nonNullBitmapSlices = new Slice[data.getColumnsCount()];
        for (int i = 0; i < data.getColumnsCount(); ++i) {
            WireProtocol.ColumnarRowBlockPB.Column column = data.getColumns(i);
            dataSlices[i] = callResponse.getSidecar(column.getDataSidecar());
            varlenDataSlices[i] = callResponse.getSidecar(column.getVarlenDataSidecar());
            nonNullBitmapSlices[i] = callResponse.getSidecar(column.getNonNullBitmapSidecar());
        }
        int numRows = Math.toIntExact(data.getNumRows());
        return new ColumnarRowResultIterator(elapsedMillis, tsUUID, schema, numRows, dataSlices, varlenDataSlices, nonNullBitmapSlices, reuseRowResult);
    }

    public static ColumnarRowResultIterator empty() {
        return EMPTY;
    }

    @Override
    public RowResult next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.sharedRowResult != null) {
            this.sharedRowResult.advancePointerTo(this.currentRow++);
            return this.sharedRowResult;
        }
        return new ColumnarRowResult(this.schema, this.data, this.varlenData, this.nonNullBitmaps, this.currentRow++);
    }

    public String toString() {
        return "RowResultColumnarIterator for " + this.numRows + " rows";
    }
}

