/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.kudu.client.AbortTransactionResponse;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.shaded.com.google.common.collect.ImmutableList;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.io.netty.util.Timer;
import org.apache.kudu.transactions.TxnManager;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AbortTransactionRequest
extends KuduRpc<AbortTransactionResponse> {
    private static final List<Integer> featureFlags = ImmutableList.of();
    final long txnId;

    AbortTransactionRequest(KuduTable masterTable, Timer timer, long timeoutMillis, long txnId) {
        super(masterTable, timer, timeoutMillis);
        Preconditions.checkArgument(txnId > -1L);
        this.txnId = txnId;
    }

    @Override
    Message createRequestPB() {
        TxnManager.AbortTransactionRequestPB.Builder b = TxnManager.AbortTransactionRequestPB.newBuilder();
        b.setTxnId(this.txnId);
        return b.build();
    }

    @Override
    String serviceName() {
        return "kudu.transactions.TxnManagerService";
    }

    @Override
    String method() {
        return "AbortTransaction";
    }

    @Override
    Pair<AbortTransactionResponse, Object> deserialize(CallResponse callResponse, String serverUUID) throws KuduException {
        TxnManager.AbortTransactionResponsePB.Builder b = TxnManager.AbortTransactionResponsePB.newBuilder();
        AbortTransactionRequest.readProtobuf(callResponse.getPBMessage(), b);
        AbortTransactionResponse response = new AbortTransactionResponse(this.timeoutTracker.getElapsedMillis(), serverUUID);
        return new Pair<AbortTransactionResponse, Object>(response, b.hasError() ? b.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return featureFlags;
    }
}

