/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.ArrayList;
import org.apache.kudu.Common;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.RemoteTablet;
import org.apache.kudu.client.SplitKeyRangeResponse;
import org.apache.kudu.security.Token;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.UnsafeByteOperations;
import org.apache.kudu.shaded.org.jboss.netty.util.Timer;
import org.apache.kudu.tserver.Tserver;
import org.apache.kudu.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class SplitKeyRangeRequest
extends KuduRpc<SplitKeyRangeResponse> {
    private final byte[] startPrimaryKey;
    private final byte[] endPrimaryKey;
    private final byte[] partitionKey;
    private final long splitSizeBytes;
    private Token.SignedTokenPB authzToken;

    SplitKeyRangeRequest(KuduTable table, byte[] startPrimaryKey, byte[] endPrimaryKey, byte[] partitionKey, long splitSizeBytes, Timer timer, long timeoutMillis) {
        super(table, timer, timeoutMillis);
        this.startPrimaryKey = startPrimaryKey;
        this.endPrimaryKey = endPrimaryKey;
        this.partitionKey = partitionKey;
        this.splitSizeBytes = splitSizeBytes;
    }

    @Override
    Message createRequestPB() {
        RemoteTablet tablet = super.getTablet();
        Tserver.SplitKeyRangeRequestPB.Builder builder = Tserver.SplitKeyRangeRequestPB.newBuilder();
        builder.setTabletId(UnsafeByteOperations.unsafeWrap(tablet.getTabletIdAsBytes()));
        if (this.startPrimaryKey != null && this.startPrimaryKey.length > 0) {
            builder.setStartPrimaryKey(UnsafeByteOperations.unsafeWrap(this.startPrimaryKey));
        }
        if (this.endPrimaryKey != null && this.endPrimaryKey.length > 0) {
            builder.setStopPrimaryKey(UnsafeByteOperations.unsafeWrap(this.endPrimaryKey));
        }
        builder.setTargetChunkSizeBytes(this.splitSizeBytes);
        if (this.authzToken != null) {
            builder.setAuthzToken(this.authzToken);
        }
        return builder.build();
    }

    @Override
    boolean needsAuthzToken() {
        return true;
    }

    @Override
    void bindAuthzToken(Token.SignedTokenPB token) {
        this.authzToken = token;
    }

    @Override
    String serviceName() {
        return "kudu.tserver.TabletServerService";
    }

    @Override
    String method() {
        return "SplitKeyRange";
    }

    @Override
    Pair<SplitKeyRangeResponse, Object> deserialize(CallResponse callResponse, String tsUuid) {
        Tserver.SplitKeyRangeResponsePB.Builder respBuilder = Tserver.SplitKeyRangeResponsePB.newBuilder();
        SplitKeyRangeRequest.readProtobuf(callResponse.getPBMessage(), respBuilder);
        ArrayList<Common.KeyRangePB> keyRanges = new ArrayList<Common.KeyRangePB>();
        for (Common.KeyRangePB keyRange : respBuilder.getRangesList()) {
            keyRanges.add(keyRange);
        }
        SplitKeyRangeResponse response = new SplitKeyRangeResponse(this.timeoutTracker.getElapsedMillis(), tsUuid, keyRanges);
        return new Pair<SplitKeyRangeResponse, Object>(response, respBuilder.hasError() ? respBuilder.getError() : null);
    }

    @Override
    byte[] partitionKey() {
        return this.partitionKey;
    }
}

