/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduException;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.LocatedTablet;
import org.apache.kudu.client.NonCoveredRangeException;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.Partition;
import org.apache.kudu.client.PartitionSchema;
import org.apache.kudu.client.TimeoutTracker;
import org.apache.kudu.shaded.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class KuduPartitioner {
    private static final BytesKey EMPTY = new BytesKey(new byte[0]);
    private static final int NON_COVERED_RANGE_INDEX = -1;
    private final PartitionSchema partitionSchema;
    private final Map<String, Partition> tabletIdToPartition;
    private final NavigableMap<BytesKey, Integer> partitionByStartKey;
    private final int numPartitions;

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public KuduPartitioner(PartitionSchema partitionSchema, Map<String, Partition> tabletIdToPartition) {
        TreeMap<BytesKey, Integer> partitionByStartKey = new TreeMap<BytesKey, Integer>();
        partitionByStartKey.put(EMPTY, -1);
        int index = 0;
        for (Map.Entry<String, Partition> entry : tabletIdToPartition.entrySet()) {
            BytesKey keyStart = new BytesKey(entry.getValue().partitionKeyStart);
            BytesKey keyEnd = new BytesKey(entry.getValue().partitionKeyEnd);
            partitionByStartKey.put(keyStart, index++);
            partitionByStartKey.putIfAbsent(keyEnd, -1);
        }
        this.partitionSchema = partitionSchema;
        this.tabletIdToPartition = tabletIdToPartition;
        this.partitionByStartKey = partitionByStartKey;
        this.numPartitions = tabletIdToPartition.size();
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public boolean isCovered(PartialRow row) {
        BytesKey partitionKey = new BytesKey(this.encodePartitionKey(row));
        Map.Entry<BytesKey, Integer> floor = this.partitionByStartKey.floorEntry(partitionKey);
        return floor.getValue() != -1;
    }

    public int partitionRow(PartialRow row) throws NonCoveredRangeException {
        BytesKey partitionKey = new BytesKey(this.encodePartitionKey(row));
        Map.Entry<BytesKey, Integer> floor = this.partitionByStartKey.floorEntry(partitionKey);
        if (floor.getValue() == -1) {
            Map.Entry<BytesKey, Integer> ceiling = this.partitionByStartKey.ceilingEntry(partitionKey);
            throw new NonCoveredRangeException(floor.getKey().bytes, ceiling.getKey().bytes);
        }
        return floor.getValue();
    }

    private byte[] encodePartitionKey(PartialRow row) {
        Preconditions.checkArgument(row.getSchema().hasColumnIds(), "The row must be constructed with a schema returned from the server. (ex: KuduTable.getSchema().newPartialRow();");
        return this.partitionSchema.encodePartitionKey(row);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public Map<String, Partition> getTabletMap() {
        return this.tabletIdToPartition;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class KuduPartitionerBuilder {
        private final KuduTable table;
        private long timeoutMillis;

        public KuduPartitionerBuilder(KuduTable table) {
            this.table = table;
            this.timeoutMillis = table.getAsyncClient().getDefaultAdminOperationTimeoutMs();
        }

        public KuduPartitionerBuilder buildTimeout(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public KuduPartitioner build() throws KuduException {
            TimeoutTracker timeoutTracker = new TimeoutTracker();
            timeoutTracker.setTimeout(this.timeoutMillis);
            LinkedHashMap<String, Partition> tabletIdToPartition = new LinkedHashMap<String, Partition>();
            byte[] nextPartKey = EMPTY.bytes;
            while (true) {
                LocatedTablet tablet;
                try {
                    tablet = KuduClient.joinAndHandleException(this.table.getAsyncClient().getTabletLocation(this.table, nextPartKey, AsyncKuduClient.LookupType.LOWER_BOUND, timeoutTracker.getMillisBeforeTimeout()));
                }
                catch (NonCoveredRangeException ncr) {
                    break;
                }
                String tabletId = new String(tablet.getTabletId(), StandardCharsets.UTF_8);
                tabletIdToPartition.put(tabletId, tablet.getPartition());
                byte[] keyEnd = tablet.getPartition().partitionKeyEnd;
                if (keyEnd.length == 0) break;
                nextPartKey = keyEnd;
            }
            return new KuduPartitioner(this.table.getPartitionSchema(), tabletIdToPartition);
        }
    }

    private static class BytesKey
    implements Comparable<BytesKey> {
        private final byte[] bytes;

        BytesKey(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean isEmpty() {
            return this.bytes.length == 0;
        }

        @Override
        public int compareTo(BytesKey other) {
            return Bytes.memcmp(this.bytes, other.bytes);
        }

        public String toString() {
            return Bytes.hex(this.bytes);
        }
    }
}

