/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.TimeZone;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.util.Slice;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowResult {
    private static final int INDEX_RESET_LOCATION = -1;
    private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    };
    private static final long MS_IN_S = 1000L;
    private static final long US_IN_S = 1000000L;
    private int index = -1;
    private int offset;
    private BitSet nullsBitSet;
    private final int rowSize;
    private final int[] columnOffsets;
    private final Schema schema;
    private final Slice rowData;
    private final Slice indirectData;

    RowResult(Schema schema, Slice rowData, Slice indirectData) {
        int currentOffset;
        this.schema = schema;
        this.rowData = rowData;
        this.indirectData = indirectData;
        int columnOffsetsSize = schema.getColumnCount();
        if (schema.hasNullableColumns()) {
            ++columnOffsetsSize;
        }
        this.rowSize = this.schema.getRowSize();
        this.columnOffsets = new int[columnOffsetsSize];
        if (columnOffsetsSize == 0) {
            return;
        }
        this.columnOffsets[0] = currentOffset = 0;
        for (int i = 1; i < columnOffsetsSize; ++i) {
            int previousSize = schema.getColumnByIndex(i - 1).getType().getSize();
            this.columnOffsets[i] = previousSize + currentOffset;
            currentOffset += previousSize;
        }
    }

    void advancePointer() {
        this.advancePointerTo(this.index + 1);
    }

    void resetPointer() {
        this.advancePointerTo(-1);
    }

    void advancePointerTo(int rowIndex) {
        this.index = rowIndex;
        this.offset = this.rowSize * this.index;
        if (this.schema.hasNullableColumns() && this.index != -1) {
            this.nullsBitSet = Bytes.toBitSet(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(this.schema.getColumnCount()), this.schema.getColumnCount());
        }
    }

    int getCurrentRowDataOffsetForColumn(int columnIndex) {
        return this.offset + this.columnOffsets[columnIndex];
    }

    public int getInt(String columnName) {
        return this.getInt(this.schema.getColumnIndex(columnName));
    }

    public int getInt(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT32);
        return Bytes.getInt(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public short getShort(String columnName) {
        return this.getShort(this.schema.getColumnIndex(columnName));
    }

    public short getShort(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT16);
        return Bytes.getShort(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public boolean getBoolean(String columnName) {
        return this.getBoolean(this.schema.getColumnIndex(columnName));
    }

    public boolean getBoolean(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BOOL);
        byte b = Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
        return b == 1;
    }

    public byte getByte(String columnName) {
        return this.getByte(this.schema.getColumnIndex(columnName));
    }

    public byte getByte(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT8);
        return Bytes.getByte(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public long getLong(String columnName) {
        return this.getLong(this.schema.getColumnIndex(columnName));
    }

    public long getLong(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        return Bytes.getLong(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public float getFloat(String columnName) {
        return this.getFloat(this.schema.getColumnIndex(columnName));
    }

    public float getFloat(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.FLOAT);
        return Bytes.getFloat(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public double getDouble(String columnName) {
        return this.getDouble(this.schema.getColumnIndex(columnName));
    }

    public double getDouble(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DOUBLE);
        return Bytes.getDouble(this.rowData.getRawArray(), this.rowData.getRawOffset() + this.getCurrentRowDataOffsetForColumn(columnIndex));
    }

    public Schema getColumnProjection() {
        return this.schema;
    }

    public String getString(String columnName) {
        return this.getString(this.schema.getColumnIndex(columnName));
    }

    public String getString(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.STRING);
        long offset = this.getLong(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return Bytes.getString(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    public byte[] getBinaryCopy(String columnName) {
        return this.getBinaryCopy(this.schema.getColumnIndex(columnName));
    }

    public byte[] getBinaryCopy(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        long offset = this.getLong(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        byte[] ret = new byte[(int)length];
        System.arraycopy(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, ret, 0, (int)length);
        return ret;
    }

    public ByteBuffer getBinary(String columnName) {
        return this.getBinary(this.schema.getColumnIndex(columnName));
    }

    public ByteBuffer getBinary(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BINARY);
        long offset = this.getLong(columnIndex);
        long length = this.rowData.getLong(this.getCurrentRowDataOffsetForColumn(columnIndex) + 8);
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return ByteBuffer.wrap(this.indirectData.getRawArray(), this.indirectData.getRawOffset() + (int)offset, (int)length);
    }

    public boolean isNull(String columnName) {
        return this.isNull(this.schema.getColumnIndex(columnName));
    }

    public boolean isNull(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (this.nullsBitSet == null) {
            return false;
        }
        return this.schema.getColumnByIndex(columnIndex).isNullable() && this.nullsBitSet.get(columnIndex);
    }

    public Type getColumnType(String columnName) {
        return this.schema.getColumn(columnName).getType();
    }

    public Type getColumnType(int columnIndex) {
        return this.schema.getColumnByIndex(columnIndex).getType();
    }

    public Schema getSchema() {
        return this.schema;
    }

    private void checkValidColumn(int columnIndex) {
        if (columnIndex >= this.schema.getColumnCount()) {
            throw new IndexOutOfBoundsException("Requested column is out of range, " + columnIndex + " out of " + this.schema.getColumnCount());
        }
    }

    private void checkNull(int columnIndex) {
        if (!this.schema.hasNullableColumns()) {
            return;
        }
        if (this.isNull(columnIndex)) {
            ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
            throw new IllegalArgumentException("The requested column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is null");
        }
    }

    private void checkType(int columnIndex, Type expectedType) {
        ColumnSchema columnSchema = this.schema.getColumnByIndex(columnIndex);
        Type columnType = columnSchema.getType();
        if (!columnType.equals((Object)expectedType)) {
            throw new IllegalArgumentException("Column (name: " + columnSchema.getName() + ", index: " + columnIndex + ") is of type " + columnType.getName() + " but was requested as a type " + expectedType.getName());
        }
    }

    public String toString() {
        return "RowResult index: " + this.index + ", size: " + this.rowSize + ", " + "schema: " + this.schema;
    }

    static String timestampToString(long timestamp) {
        long tsMillis = timestamp / 1000L;
        long tsMicros = timestamp % 1000000L;
        StringBuffer formattedTs = new StringBuffer();
        DATE_FORMAT.get().format(new Date(tsMillis), formattedTs, new FieldPosition(0));
        formattedTs.append(String.format(".%06dZ", tsMicros));
        return formattedTs.toString();
    }

    public String rowToString() {
        StringBuilder buf = new StringBuilder();
        block12: for (int i = 0; i < this.schema.getColumnCount(); ++i) {
            ColumnSchema col = this.schema.getColumnByIndex(i);
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(col.getType().name());
            buf.append(" ").append(col.getName()).append("=");
            if (this.isNull(i)) {
                buf.append("NULL");
                continue;
            }
            switch (col.getType()) {
                case INT8: {
                    buf.append(this.getByte(i));
                    continue block12;
                }
                case INT16: {
                    buf.append(this.getShort(i));
                    continue block12;
                }
                case INT32: {
                    buf.append(this.getInt(i));
                    continue block12;
                }
                case INT64: {
                    buf.append(this.getLong(i));
                    continue block12;
                }
                case UNIXTIME_MICROS: {
                    buf.append(RowResult.timestampToString(this.getLong(i)));
                    continue block12;
                }
                case STRING: {
                    buf.append(this.getString(i));
                    continue block12;
                }
                case BINARY: {
                    buf.append(Bytes.pretty(this.getBinaryCopy(i)));
                    continue block12;
                }
                case FLOAT: {
                    buf.append(this.getFloat(i));
                    continue block12;
                }
                case DOUBLE: {
                    buf.append(this.getDouble(i));
                    continue block12;
                }
                case BOOL: {
                    buf.append(this.getBoolean(i));
                    continue block12;
                }
                default: {
                    buf.append("<unknown type!>");
                }
            }
        }
        return buf.toString();
    }

    public String toStringLongFormat() {
        StringBuilder buf = new StringBuilder(this.rowSize);
        buf.append(this.toString());
        buf.append("{");
        buf.append(this.rowToString());
        buf.append("}");
        return buf.toString();
    }
}

