/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Collection;
import java.util.List;
import org.apache.kudu.Schema;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.CreateTableOptions;
import org.apache.kudu.client.CreateTableResponse;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.shaded.com.google.protobuf.Message;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.Pair;

@InterfaceAudience.Private
class CreateTableRequest
extends KuduRpc<CreateTableResponse> {
    static final String CREATE_TABLE = "CreateTable";
    private final Schema schema;
    private final String name;
    private final Master.CreateTableRequestPB.Builder builder;
    private final List<Integer> featureFlags;

    CreateTableRequest(KuduTable masterTable, String name, Schema schema, CreateTableOptions builder) {
        super(masterTable);
        this.schema = schema;
        this.name = name;
        this.builder = builder.getBuilder();
        this.featureFlags = builder.getRequiredFeatureFlags();
    }

    @Override
    ChannelBuffer serialize(Message header) {
        assert (header.isInitialized());
        this.builder.setName(this.name);
        this.builder.setSchema(ProtobufHelper.schemaToPb(this.schema));
        return CreateTableRequest.toChannelBuffer(header, this.builder.build());
    }

    @Override
    String serviceName() {
        return "kudu.master.MasterService";
    }

    @Override
    String method() {
        return CREATE_TABLE;
    }

    @Override
    Pair<CreateTableResponse, Object> deserialize(CallResponse callResponse, String tsUUID) throws Exception {
        Master.CreateTableResponsePB.Builder builder = Master.CreateTableResponsePB.newBuilder();
        CreateTableRequest.readProtobuf(callResponse.getPBMessage(), builder);
        CreateTableResponse response = new CreateTableResponse(this.deadlineTracker.getElapsedMillis(), tsUUID);
        return new Pair<CreateTableResponse, Object>(response, builder.hasError() ? builder.getError() : null);
    }

    @Override
    Collection<Integer> getRequiredFeatures() {
        return this.featureFlags;
    }
}

