/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.CallResponse;
import org.apache.kudu.client.KuduRpc;
import org.apache.kudu.client.TabletClient;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.client.shaded.com.google.common.collect.ImmutableSet;
import org.apache.kudu.client.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.client.shaded.com.google.protobuf.ZeroCopyLiteralByteString;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffer;
import org.apache.kudu.client.shaded.org.jboss.netty.buffer.ChannelBuffers;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.rpc.RpcHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SecureRpcHelper {
    public static final Logger LOG = LoggerFactory.getLogger(TabletClient.class);
    private final TabletClient client;
    private SaslClient saslClient;
    public static final String SASL_DEFAULT_REALM = "default";
    public static final Map<String, String> SASL_PROPS = new TreeMap<String, String>();
    private static final int SASL_CALL_ID = -33;
    private static final Set<RpcHeader.RpcFeatureFlag> SUPPORTED_RPC_FEATURES = ImmutableSet.of(RpcHeader.RpcFeatureFlag.APPLICATION_FEATURE_FLAGS);
    private volatile boolean negoUnderway = true;
    private boolean useWrap = false;
    private Set<RpcHeader.RpcFeatureFlag> serverFeatures;
    public static final String USER_AND_PASSWORD = "java_client";

    public SecureRpcHelper(TabletClient client) {
        this.client = client;
        try {
            this.saslClient = Sasl.createSaslClient(new String[]{"PLAIN"}, null, null, SASL_DEFAULT_REALM, SASL_PROPS, new SaslClientCallbackHandler(USER_AND_PASSWORD, USER_AND_PASSWORD));
        }
        catch (SaslException e) {
            throw new RuntimeException("Could not create the SASL client", e);
        }
    }

    public Set<RpcHeader.RpcFeatureFlag> getServerFeatures() {
        Preconditions.checkState(!this.negoUnderway);
        Preconditions.checkNotNull(this.serverFeatures);
        return this.serverFeatures;
    }

    public void sendHello(Channel channel) {
        this.sendNegotiateMessage(channel);
    }

    private void sendNegotiateMessage(Channel channel) {
        RpcHeader.SaslMessagePB.Builder builder = RpcHeader.SaslMessagePB.newBuilder();
        for (RpcHeader.RpcFeatureFlag flag : SUPPORTED_RPC_FEATURES) {
            builder.addSupportedFeatures(flag);
        }
        builder.setState(RpcHeader.SaslMessagePB.SaslState.NEGOTIATE);
        this.sendSaslMessage(channel, builder.build());
    }

    private void sendSaslMessage(Channel channel, RpcHeader.SaslMessagePB msg) {
        RpcHeader.RequestHeader.Builder builder = RpcHeader.RequestHeader.newBuilder();
        builder.setCallId(-33);
        RpcHeader.RequestHeader header = builder.build();
        ChannelBuffer buffer = KuduRpc.toChannelBuffer(header, msg);
        Channels.write(channel, buffer);
    }

    public ChannelBuffer handleResponse(ChannelBuffer buf, Channel chan) throws SaslException {
        if (!this.saslClient.isComplete() || this.negoUnderway) {
            RpcHeader.SaslMessagePB response = this.parseSaslMsgResponse(buf);
            switch (response.getState()) {
                case NEGOTIATE: {
                    this.handleNegotiateResponse(chan, response);
                    break;
                }
                case CHALLENGE: {
                    this.handleChallengeResponse(chan, response);
                    break;
                }
                case SUCCESS: {
                    this.handleSuccessResponse(chan, response);
                    break;
                }
                default: {
                    System.out.println("Wrong sasl state");
                }
            }
            return null;
        }
        return this.unwrap(buf);
    }

    public ChannelBuffer unwrap(ChannelBuffer payload) {
        if (!this.useWrap) {
            return payload;
        }
        int len = payload.readInt();
        try {
            payload = ChannelBuffers.wrappedBuffer(this.saslClient.unwrap(payload.readBytes(len).array(), 0, len));
            return payload;
        }
        catch (SaslException e) {
            throw new IllegalStateException("Failed to unwrap payload", e);
        }
    }

    public ChannelBuffer wrap(ChannelBuffer content) {
        if (!this.useWrap) {
            return content;
        }
        try {
            byte[] payload = new byte[content.writerIndex()];
            content.readBytes(payload);
            byte[] wrapped = this.saslClient.wrap(payload, 0, payload.length);
            ChannelBuffer ret = ChannelBuffers.wrappedBuffer(new byte[4 + wrapped.length]);
            ret.clear();
            ret.writeInt(wrapped.length);
            ret.writeBytes(wrapped);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wrapped payload: " + Bytes.pretty(ret));
            }
            return ret;
        }
        catch (SaslException e) {
            throw new IllegalStateException("Failed to wrap payload", e);
        }
    }

    private RpcHeader.SaslMessagePB parseSaslMsgResponse(ChannelBuffer buf) {
        CallResponse response = new CallResponse(buf);
        RpcHeader.ResponseHeader responseHeader = response.getHeader();
        int id = responseHeader.getCallId();
        if (id != -33) {
            throw new IllegalStateException("Received a call that wasn't for SASL");
        }
        RpcHeader.SaslMessagePB.Builder saslBuilder = RpcHeader.SaslMessagePB.newBuilder();
        KuduRpc.readProtobuf(response.getPBMessage(), saslBuilder);
        return saslBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private void handleNegotiateResponse(Channel chan, RpcHeader.SaslMessagePB response) throws SaslException {
        void var5_9;
        RpcHeader.SaslMessagePB.SaslAuth negotiatedAuth = null;
        Iterator<RpcHeader.SaslMessagePB.SaslAuth> iterator = response.getAuthsList().iterator();
        while (iterator.hasNext()) {
            RpcHeader.SaslMessagePB.SaslAuth saslAuth;
            negotiatedAuth = saslAuth = iterator.next();
        }
        ImmutableSet.Builder features = ImmutableSet.builder();
        for (RpcHeader.RpcFeatureFlag feature : response.getSupportedFeaturesList()) {
            if (!SUPPORTED_RPC_FEATURES.contains(feature)) continue;
            features.add(feature);
        }
        this.serverFeatures = features.build();
        byte[] byArray = new byte[]{};
        if (this.saslClient.hasInitialResponse()) {
            byte[] byArray2 = this.saslClient.evaluateChallenge(byArray);
        }
        RpcHeader.SaslMessagePB.Builder builder = RpcHeader.SaslMessagePB.newBuilder();
        if (var5_9 != null) {
            builder.setToken(ZeroCopyLiteralByteString.wrap((byte[])var5_9));
        }
        builder.setState(RpcHeader.SaslMessagePB.SaslState.INITIATE);
        builder.addAuths(negotiatedAuth);
        this.sendSaslMessage(chan, builder.build());
    }

    private void handleChallengeResponse(Channel chan, RpcHeader.SaslMessagePB response) throws SaslException {
        ByteString bs = response.getToken();
        byte[] saslToken = this.saslClient.evaluateChallenge(bs.toByteArray());
        if (saslToken == null) {
            throw new IllegalStateException("Not expecting an empty token");
        }
        RpcHeader.SaslMessagePB.Builder builder = RpcHeader.SaslMessagePB.newBuilder();
        builder.setToken(ZeroCopyLiteralByteString.wrap(saslToken));
        builder.setState(RpcHeader.SaslMessagePB.SaslState.RESPONSE);
        this.sendSaslMessage(chan, builder.build());
    }

    private void handleSuccessResponse(Channel chan, RpcHeader.SaslMessagePB response) {
        LOG.debug("nego finished");
        this.negoUnderway = false;
        this.client.sendContext(chan);
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(String user, String password) {
            this.userName = user;
            this.userPassword = password.toCharArray();
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL client callback");
            }
            if (nc != null) {
                nc.setName(this.userName);
            }
            if (pc != null) {
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

