/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kudu.Common;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.client.GetMasterRegistrationResponse;
import org.apache.kudu.client.NoLeaderMasterFoundException;
import org.apache.kudu.client.NonRecoverableException;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.Status;
import org.apache.kudu.client.shaded.com.google.common.base.Functions;
import org.apache.kudu.client.shaded.com.google.common.base.Joiner;
import org.apache.kudu.client.shaded.com.google.common.collect.Lists;
import org.apache.kudu.client.shaded.com.google.common.net.HostAndPort;
import org.apache.kudu.client.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.consensus.Metadata;
import org.apache.kudu.master.Master;
import org.apache.kudu.util.NetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
final class GetMasterRegistrationReceived {
    private static final Logger LOG = LoggerFactory.getLogger(GetMasterRegistrationReceived.class);
    private final List<HostAndPort> masterAddrs;
    private final Deferred<Master.GetTableLocationsResponsePB> responseD;
    private final int numMasters;
    private final AtomicBoolean responseDCalled = new AtomicBoolean(false);
    private final AtomicInteger countResponsesReceived = new AtomicInteger(0);
    private final List<Exception> exceptionsReceived = Collections.synchronizedList(new ArrayList());

    public GetMasterRegistrationReceived(List<HostAndPort> masterAddrs, Deferred<Master.GetTableLocationsResponsePB> responseD) {
        this.masterAddrs = masterAddrs;
        this.responseD = responseD;
        this.numMasters = masterAddrs.size();
    }

    public Callback<Void, GetMasterRegistrationResponse> callbackForNode(HostAndPort hostAndPort) {
        return new GetMasterRegistrationCB(hostAndPort);
    }

    public Callback<Void, Exception> errbackForNode(HostAndPort hostAndPort) {
        return new GetMasterRegistrationErrCB(hostAndPort);
    }

    private void incrementCountAndCheckExhausted() {
        if (this.countResponsesReceived.incrementAndGet() == this.numMasters && this.responseDCalled.compareAndSet(false, true)) {
            boolean allUnrecoverable = true;
            if (this.exceptionsReceived.size() == this.countResponsesReceived.get()) {
                for (Exception ex : this.exceptionsReceived) {
                    if (ex instanceof NonRecoverableException) continue;
                    allUnrecoverable = false;
                    break;
                }
            } else {
                allUnrecoverable = false;
            }
            String allHosts = NetUtil.hostsAndPortsToString(this.masterAddrs);
            if (allUnrecoverable) {
                String msg = String.format("Couldn't find a valid master in (%s). Exceptions received: %s", allHosts, Joiner.on(",").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction())));
                Status s = Status.ServiceUnavailable(msg);
                this.responseD.callback((Object)new NonRecoverableException(s));
            } else {
                NoLeaderMasterFoundException ex;
                String message = String.format("Master config (%s) has no leader.", allHosts);
                if (this.exceptionsReceived.isEmpty()) {
                    LOG.warn(String.format("None of the provided masters (%s) is a leader, will retry.", allHosts));
                    ex = new NoLeaderMasterFoundException(Status.ServiceUnavailable(message));
                } else {
                    LOG.warn(String.format("Unable to find the leader master (%s), will retry", allHosts));
                    String joinedMsg = message + " Exceptions received: " + Joiner.on(",").join(Lists.transform(this.exceptionsReceived, Functions.toStringFunction()));
                    Status s = Status.ServiceUnavailable(joinedMsg);
                    ex = new NoLeaderMasterFoundException(s, this.exceptionsReceived.get(this.exceptionsReceived.size() - 1));
                }
                this.responseD.callback((Object)ex);
            }
        }
    }

    final class GetMasterRegistrationErrCB
    implements Callback<Void, Exception> {
        private final HostAndPort hostAndPort;

        public GetMasterRegistrationErrCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(Exception e) throws Exception {
            LOG.warn("Error receiving a response from: " + this.hostAndPort, (Throwable)e);
            GetMasterRegistrationReceived.this.exceptionsReceived.add(e);
            GetMasterRegistrationReceived.this.incrementCountAndCheckExhausted();
            return null;
        }

        public String toString() {
            return "get master registration errback for " + this.hostAndPort.toString();
        }
    }

    final class GetMasterRegistrationCB
    implements Callback<Void, GetMasterRegistrationResponse> {
        private final HostAndPort hostAndPort;

        public GetMasterRegistrationCB(HostAndPort hostAndPort) {
            this.hostAndPort = hostAndPort;
        }

        public Void call(GetMasterRegistrationResponse r) throws Exception {
            Master.TabletLocationsPB.ReplicaPB.Builder replicaBuilder = Master.TabletLocationsPB.ReplicaPB.newBuilder();
            Master.TSInfoPB.Builder tsInfoBuilder = Master.TSInfoPB.newBuilder();
            tsInfoBuilder.addRpcAddresses(ProtobufHelper.hostAndPortToPB(this.hostAndPort));
            tsInfoBuilder.setPermanentUuid(r.getInstanceId().getPermanentUuid());
            replicaBuilder.setTsInfo(tsInfoBuilder);
            if (r.getRole().equals(Metadata.RaftPeerPB.Role.LEADER)) {
                replicaBuilder.setRole(r.getRole());
                Master.TabletLocationsPB.Builder locationBuilder = Master.TabletLocationsPB.newBuilder();
                locationBuilder.setPartition(Common.PartitionPB.newBuilder().setPartitionKeyStart(ByteString.EMPTY).setPartitionKeyEnd(ByteString.EMPTY));
                locationBuilder.setTabletId(ByteString.copyFromUtf8("Kudu Master"));
                locationBuilder.addReplicas(replicaBuilder);
                if (GetMasterRegistrationReceived.this.responseDCalled.compareAndSet(false, true)) {
                    GetMasterRegistrationReceived.this.responseD.callback((Object)Master.GetTableLocationsResponsePB.newBuilder().addTabletLocations(locationBuilder.build()).build());
                } else {
                    LOG.debug("Callback already invoked, discarding response(" + r.toString() + ") from " + this.hostAndPort.toString());
                }
            } else {
                GetMasterRegistrationReceived.this.incrementCountAndCheckExhausted();
            }
            return null;
        }

        public String toString() {
            return "get master registration for " + this.hostAndPort.toString();
        }
    }
}

