/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import org.apache.kudu.ColumnSchema;
import org.apache.kudu.Type;
import org.apache.kudu.annotations.InterfaceAudience;
import org.apache.kudu.annotations.InterfaceStability;
import org.apache.kudu.client.Operation;
import org.apache.kudu.client.PartialRow;
import org.apache.kudu.client.ProtobufHelper;
import org.apache.kudu.client.RangePartitionBound;
import org.apache.kudu.client.shaded.com.google.common.base.Preconditions;
import org.apache.kudu.master.Master;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class AlterTableOptions {
    private final Master.AlterTableRequestPB.Builder pb = Master.AlterTableRequestPB.newBuilder();

    public AlterTableOptions renameTable(String newName) {
        this.pb.setNewTableName(newName);
        return this;
    }

    public AlterTableOptions addColumn(String name, Type type, Object defaultVal) {
        if (defaultVal == null) {
            throw new IllegalArgumentException("A new column must have a default value, use addNullableColumn() to add a NULLABLE column");
        }
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_COLUMN);
        step.setAddColumn(Master.AlterTableRequestPB.AddColumn.newBuilder().setSchema(ProtobufHelper.columnToPb(new ColumnSchema.ColumnSchemaBuilder(name, type).defaultValue(defaultVal).build())));
        return this;
    }

    public AlterTableOptions addNullableColumn(String name, Type type) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_COLUMN);
        step.setAddColumn(Master.AlterTableRequestPB.AddColumn.newBuilder().setSchema(ProtobufHelper.columnToPb(new ColumnSchema.ColumnSchemaBuilder(name, type).nullable(true).build())));
        return this;
    }

    public AlterTableOptions dropColumn(String name) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.DROP_COLUMN);
        step.setDropColumn(Master.AlterTableRequestPB.DropColumn.newBuilder().setName(name));
        return this;
    }

    public AlterTableOptions renameColumn(String oldName, String newName) {
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.RENAME_COLUMN);
        step.setRenameColumn(Master.AlterTableRequestPB.RenameColumn.newBuilder().setOldName(oldName).setNewName(newName));
        return this;
    }

    public AlterTableOptions addRangePartition(PartialRow lowerBound, PartialRow upperBound) {
        return this.addRangePartition(lowerBound, upperBound, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public AlterTableOptions addRangePartition(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        Preconditions.checkNotNull(lowerBound);
        Preconditions.checkNotNull(upperBound);
        Preconditions.checkArgument(lowerBound.getSchema().equals(upperBound.getSchema()));
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.ADD_RANGE_PARTITION);
        Master.AlterTableRequestPB.AddRangePartition.Builder builder = Master.AlterTableRequestPB.AddRangePartition.newBuilder();
        builder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(lowerBound, upperBound, lowerBoundType, upperBoundType));
        step.setAddRangePartition(builder);
        if (!this.pb.hasSchema()) {
            this.pb.setSchema(ProtobufHelper.schemaToPb(lowerBound.getSchema()));
        }
        return this;
    }

    public AlterTableOptions dropRangePartition(PartialRow lowerBound, PartialRow upperBound) {
        return this.dropRangePartition(lowerBound, upperBound, RangePartitionBound.INCLUSIVE_BOUND, RangePartitionBound.EXCLUSIVE_BOUND);
    }

    public AlterTableOptions dropRangePartition(PartialRow lowerBound, PartialRow upperBound, RangePartitionBound lowerBoundType, RangePartitionBound upperBoundType) {
        Preconditions.checkNotNull(lowerBound);
        Preconditions.checkNotNull(upperBound);
        Preconditions.checkArgument(lowerBound.getSchema().equals(upperBound.getSchema()));
        Master.AlterTableRequestPB.Step.Builder step = this.pb.addAlterSchemaStepsBuilder();
        step.setType(Master.AlterTableRequestPB.StepType.DROP_RANGE_PARTITION);
        Master.AlterTableRequestPB.DropRangePartition.Builder builder = Master.AlterTableRequestPB.DropRangePartition.newBuilder();
        builder.setRangeBounds(new Operation.OperationsEncoder().encodeLowerAndUpperBounds(lowerBound, upperBound, lowerBoundType, upperBoundType));
        step.setDropRangePartition(builder);
        if (!this.pb.hasSchema()) {
            this.pb.setSchema(ProtobufHelper.schemaToPb(lowerBound.getSchema()));
        }
        return this;
    }

    @InterfaceAudience.Private
    boolean hasAddDropRangePartitions() {
        return this.pb.hasSchema();
    }

    Master.AlterTableRequestPB.Builder getProtobuf() {
        return this.pb;
    }
}

