/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channel;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.ChannelFuture;
import org.apache.kudu.client.shaded.org.jboss.netty.channel.Channels;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout.IdleState;
import org.apache.kudu.client.shaded.org.jboss.netty.handler.timeout.IdleStateEvent;

public class DefaultIdleStateEvent
implements IdleStateEvent {
    private final Channel channel;
    private final IdleState state;
    private final long lastActivityTimeMillis;

    public DefaultIdleStateEvent(Channel channel, IdleState state, long lastActivityTimeMillis) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.channel = channel;
        this.state = state;
        this.lastActivityTimeMillis = lastActivityTimeMillis;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    public IdleState getState() {
        return this.state;
    }

    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public String toString() {
        return this.getChannel().toString() + ' ' + (Object)((Object)this.getState()) + " since " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date(this.getLastActivityTimeMillis()));
    }
}

