/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.util.concurrent.TimeUnit;
import org.apache.kudu.client.shaded.com.google.common.base.Stopwatch;

public class DeadlineTracker {
    private final Stopwatch stopwatch;
    private long deadline = 0L;

    public DeadlineTracker() {
        this(Stopwatch.createUnstarted());
    }

    public DeadlineTracker(Stopwatch stopwatch) {
        if (stopwatch.isRunning()) {
            stopwatch.reset();
        }
        this.stopwatch = stopwatch.start();
    }

    public boolean timedOut() {
        if (!this.hasDeadline()) {
            return false;
        }
        return this.deadline - this.stopwatch.elapsed(TimeUnit.MILLISECONDS) <= 0L;
    }

    public long getMillisBeforeDeadline() {
        if (!this.hasDeadline()) {
            throw new IllegalStateException("This tracker doesn't have a deadline set so it cannot answer getMillisBeforeDeadline()");
        }
        long millisBeforeDeadline = this.deadline - this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        millisBeforeDeadline = millisBeforeDeadline <= 0L ? 1L : millisBeforeDeadline;
        return millisBeforeDeadline;
    }

    public long getElapsedMillis() {
        return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    public boolean hasDeadline() {
        return this.deadline != 0L;
    }

    public boolean wouldSleepingTimeout(long plannedSleepTime) {
        if (!this.hasDeadline()) {
            return false;
        }
        return this.getMillisBeforeDeadline() - plannedSleepTime <= 0L;
    }

    public void reset() {
        this.deadline = 0L;
        this.stopwatch.reset();
        this.stopwatch.start();
    }

    public long getDeadline() {
        return this.deadline;
    }

    public void setDeadline(long deadline) {
        if (deadline < 0L) {
            throw new IllegalArgumentException("The deadline must be greater or equal to 0, the passed value is " + deadline);
        }
        this.deadline = deadline;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("DeadlineTracker(timeout=");
        buf.append(this.deadline);
        buf.append(", elapsed=").append(this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        buf.append(")");
        return buf.toString();
    }
}

