/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kdc.impl;

import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.kerby.kerberos.kdc.impl.NettyKdcNetwork;
import org.apache.kerby.kerberos.kerb.server.KdcContext;
import org.apache.kerby.kerberos.kerb.server.KdcSetting;
import org.apache.kerby.kerberos.kerb.server.impl.AbstractInternalKdcServer;
import org.apache.kerby.kerberos.kerb.server.preauth.PreauthHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyKdcServerImpl
extends AbstractInternalKdcServer {
    private ExecutorService executor;
    private KdcContext kdcContext;
    private NettyKdcNetwork network;
    private static final Logger LOG = LoggerFactory.getLogger(NettyKdcServerImpl.class);

    public NettyKdcServerImpl(KdcSetting kdcSetting) {
        super(kdcSetting);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.prepareHandler();
        this.executor = Executors.newCachedThreadPool();
        this.network = new NettyKdcNetwork();
        this.network.init(this.kdcContext);
        InetSocketAddress udpAddress = null;
        InetSocketAddress tcpAddress = new InetSocketAddress(this.getSetting().getKdcHost(), this.getSetting().getKdcTcpPort());
        if (this.getSetting().allowUdp()) {
            udpAddress = new InetSocketAddress(this.getSetting().getKdcHost(), this.getSetting().getKdcUdpPort());
        }
        this.network.listen(tcpAddress, udpAddress);
        this.network.start();
        LOG.info("Netty kdc server started.");
    }

    private void prepareHandler() {
        this.kdcContext = new KdcContext(this.getSetting());
        this.kdcContext.setIdentityService(this.getIdentityService());
        PreauthHandler preauthHandler = new PreauthHandler();
        preauthHandler.init();
        this.kdcContext.setPreauthHandler(preauthHandler);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.network != null) {
            this.network.stop();
        }
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                boolean terminated = false;
                while (!(terminated = this.executor.awaitTermination(60L, TimeUnit.SECONDS))) {
                }
            }
            catch (InterruptedException e) {
                this.executor.shutdownNow();
                LOG.warn("waitForTermination interrupted");
            }
        }
        LOG.info("Netty kdc server stopped.");
    }
}

