/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerContext;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerSetting;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerUtil;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl.AbstractInternalAdminServer;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl.DefaultAdminServerHandler;
import org.apache.kerby.kerberos.kerb.transport.KdcNetwork;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;

public class DefaultInternalAdminServerImpl
extends AbstractInternalAdminServer {
    private ExecutorService executor;
    private AdminServerContext adminContext;
    private KdcNetwork network;

    public DefaultInternalAdminServerImpl(AdminServerSetting adminSetting) {
        super(adminSetting);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.prepareHandler();
        this.executor = Executors.newCachedThreadPool();
        this.network = new KdcNetwork(){

            protected void onNewTransport(KrbTransport transport) {
                DefaultAdminServerHandler kdcHandler = new DefaultAdminServerHandler(DefaultInternalAdminServerImpl.this.adminContext, transport);
                DefaultInternalAdminServerImpl.this.executor.execute(kdcHandler);
            }
        };
        this.network.init();
        TransportPair tpair = AdminServerUtil.getTransportPair(this.getSetting());
        this.network.listen(tpair);
        this.network.start();
    }

    private void prepareHandler() {
        this.adminContext = new AdminServerContext(this.getSetting());
        this.adminContext.setIdentityService(this.getIdentityService());
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.network.stop();
        this.executor.shutdownNow();
    }
}

