/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.kerby.kerberos.kerb.admin.AuthUtil;
import org.apache.kerby.kerberos.kerb.admin.kadmin.remote.NegotiationStatus;
import org.apache.kerby.kerberos.kerb.admin.message.KadminCode;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerContext;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerHandler;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerUtil;
import org.apache.kerby.kerberos.kerb.common.KrbUtil;
import org.apache.kerby.kerberos.kerb.transport.KrbTcpTransport;
import org.apache.kerby.kerberos.kerb.transport.KrbTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

public class DefaultAdminServerHandler
extends AdminServerHandler
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(DefaultAdminServerHandler.class);
    private static final String MECHANISM = "GSSAPI";
    private final KrbTransport transport;
    private AdminServerContext adminServerContext;

    public DefaultAdminServerHandler(AdminServerContext adminServerContext, KrbTransport transport) {
        super(adminServerContext);
        this.transport = transport;
        this.adminServerContext = adminServerContext;
    }

    @Override
    public void run() {
        try {
            this.doSaslHandshake();
        }
        catch (Exception e) {
            logger.error("With exception when SASL negotiation." + e);
            return;
        }
        do {
            try {
                ByteBuffer message = this.transport.receiveMessage();
                if (message == null) {
                    logger.debug("No valid request recved. Disconnect actively");
                    this.transport.release();
                    break;
                }
                ByteBuffer unwrapMessage = ByteBuffer.wrap(this.getSaslServerWrapper().unwrap(message));
                this.handleMessage(unwrapMessage);
            }
            catch (IOException e) {
                this.transport.release();
                logger.debug("Transport or decoding error occurred, disconnecting abnormally", (Throwable)e);
                break;
            }
        } while (!((KrbTcpTransport)this.transport).isClosed());
    }

    protected void handleMessage(ByteBuffer message) {
        InetAddress clientAddress = this.transport.getRemoteAddress();
        try {
            ByteBuffer adminResponse = this.handleMessage(message, clientAddress);
            this.transport.sendMessage(adminResponse);
        }
        catch (Exception e) {
            this.transport.release();
            logger.error("Error occured while processing request:", (Throwable)e);
        }
    }

    private void doSaslHandshake() throws Exception {
        File keytabFile = new File(this.adminServerContext.getConfig().getKeyTabFile());
        String principal = this.adminServerContext.getConfig().getProtocol() + "/" + this.adminServerContext.getConfig().getAdminHost();
        String fixedPrincipal = AdminServerUtil.fixPrincipal(principal, this.adminServerContext.getAdminServerSetting());
        String adminPrincipal = KrbUtil.makeKadminPrincipal((String)this.adminServerContext.getAdminServerSetting().getKdcRealm()).getName();
        Subject subject = AuthUtil.loginUsingKeytab((String)fixedPrincipal, (File)keytabFile);
        Subject.doAs(subject, () -> {
            boolean success = false;
            try {
                ByteBuffer message;
                try {
                    message = this.transport.receiveMessage();
                }
                catch (SocketTimeoutException ignore) {
                    Object var5_6 = null;
                    if (!success) {
                        this.transport.release();
                    }
                    return var5_6;
                }
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("javax.security.sasl.qop", "auth-conf");
                props.put("javax.security.sasl.server.authentication", "true");
                String protocol = this.adminServerContext.getConfig().getProtocol();
                String serverName = this.adminServerContext.getConfig().getServerName();
                SaslGssCallbackHandler callbackHandler = new SaslGssCallbackHandler(adminPrincipal);
                SaslServer saslServer = Sasl.createSaslServer(MECHANISM, protocol, serverName, props, callbackHandler);
                if (saslServer == null) {
                    throw new Exception("Unable to find server implementation for: GSSAPI");
                }
                this.setSaslServerWrapper(SaslWrapper.create((SaslServer)saslServer));
                while (!saslServer.isComplete()) {
                    int scComplete = message.getInt();
                    if (scComplete == NegotiationStatus.SUCCESS.getValue()) {
                        logger.info("Sasl Client completed");
                    }
                    byte[] challenge = null;
                    try {
                        challenge = SaslUtils.evaluateResponse((SaslServer)saslServer, (ByteBuffer)message);
                    }
                    catch (SaslException e) {
                        throw new Exception("Sasl server evaluate challenge failed. " + e);
                    }
                    if (saslServer.isComplete()) continue;
                    this.sendMessage(challenge, saslServer);
                    logger.info("Waiting receive message");
                    message = this.transport.receiveMessage();
                }
                success = true;
            }
            finally {
                if (!success) {
                    this.transport.release();
                }
            }
            return null;
        });
    }

    private void sendMessage(byte[] challenge, SaslServer saslServer) throws IOException {
        NegotiationStatus status = saslServer.isComplete() ? NegotiationStatus.SUCCESS : NegotiationStatus.CONTINUE;
        ByteBuffer buffer = KadminCode.encodeSaslMessage((byte[])challenge, (NegotiationStatus)status);
        try {
            this.transport.sendMessage(buffer);
            logger.info("Send message to admin client.");
        }
        catch (SaslException e) {
            logger.error("Failed to send message to client. " + e.toString());
        }
    }

    private static class SaslGssCallbackHandler
    implements CallbackHandler {
        private final String adminPrincipal;

        SaslGssCallbackHandler(String principal) {
            this.adminPrincipal = principal;
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID()) && authid.equals(this.adminPrincipal)) {
                    ac.setAuthorized(true);
                } else {
                    logger.warn("Client try to login using principal " + authid);
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

