/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl;

import org.apache.kerby.config.Config;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfig;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerSetting;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl.InternalAdminServer;
import org.apache.kerby.kerberos.kerb.identity.CacheableIdentityService;
import org.apache.kerby.kerberos.kerb.identity.IdentityService;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.identity.backend.MemoryIdentityBackend;
import org.apache.kerby.kerberos.kerb.server.KdcUtil;

public class AbstractInternalAdminServer
implements InternalAdminServer {
    private boolean started;
    private final AdminServerConfig adminServerConfig;
    private final BackendConfig backendConfig;
    private final AdminServerSetting adminServerSetting;
    private IdentityBackend backend;
    private IdentityService identityService;

    public AbstractInternalAdminServer(AdminServerSetting adminServerSetting) {
        this.adminServerSetting = adminServerSetting;
        this.adminServerConfig = adminServerSetting.getAdminServerConfig();
        this.backendConfig = adminServerSetting.getBackendConfig();
    }

    @Override
    public AdminServerSetting getSetting() {
        return this.adminServerSetting;
    }

    public boolean isStarted() {
        return this.started;
    }

    protected String getServiceName() {
        return this.adminServerConfig.getAdminServiceName();
    }

    protected IdentityService getIdentityService() {
        if (this.identityService == null) {
            this.identityService = this.backend instanceof MemoryIdentityBackend ? this.backend : new CacheableIdentityService((Config)this.backendConfig, (IdentityService)this.backend);
        }
        return this.identityService;
    }

    @Override
    public void init() throws KrbException {
        this.backend = KdcUtil.getBackend((BackendConfig)this.backendConfig);
    }

    @Override
    public void start() throws KrbException {
        try {
            this.doStart();
        }
        catch (Exception e) {
            throw new KrbException("Failed to start " + this.getServiceName(), (Throwable)e);
        }
        this.started = true;
    }

    public boolean enableDebug() {
        return this.adminServerConfig.enableDebug();
    }

    @Override
    public IdentityBackend getIdentityBackend() {
        return this.backend;
    }

    protected void doStart() throws Exception {
        this.backend.start();
    }

    @Override
    public void stop() throws KrbException {
        try {
            this.doStop();
        }
        catch (Exception e) {
            throw new KrbException("Failed to stop " + this.getServiceName(), (Throwable)e);
        }
        this.started = false;
    }

    protected void doStop() throws Exception {
        this.backend.stop();
    }
}

