/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfig;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerSetting;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;
import org.apache.kerby.kerberos.kerb.transport.TransportPair;

public final class AdminServerUtil {
    public static AdminServerConfig getAdminServerConfig(File confDir) throws KrbException {
        File adminServerConfFile = new File(confDir, "adminServer.conf");
        if (adminServerConfFile.exists()) {
            AdminServerConfig adminServerConfig = new AdminServerConfig();
            try {
                adminServerConfig.addKrb5Config(adminServerConfFile);
            }
            catch (IOException e) {
                throw new KrbException("Can not load the adminServer configuration file " + adminServerConfFile.getAbsolutePath());
            }
            return adminServerConfig;
        }
        return null;
    }

    public static KdcConfig getKdcConfig(File confDir) throws KrbException {
        File kdcConfFile = new File(confDir, "kdc.conf");
        if (kdcConfFile.exists()) {
            KdcConfig kdcConfig = new KdcConfig();
            try {
                kdcConfig.addKrb5Config(kdcConfFile);
            }
            catch (IOException e) {
                throw new KrbException("Can not load the kdc configuration file " + kdcConfFile.getAbsolutePath());
            }
            return kdcConfig;
        }
        return null;
    }

    public static BackendConfig getBackendConfig(File confDir) throws KrbException {
        File backendConfigFile = new File(confDir, "backend.conf");
        if (backendConfigFile.exists()) {
            BackendConfig backendConfig = new BackendConfig();
            try {
                backendConfig.addIniConfig(backendConfigFile);
            }
            catch (IOException e) {
                throw new KrbException("Can not load the backend configuration file " + backendConfigFile.getAbsolutePath());
            }
            return backendConfig;
        }
        return null;
    }

    public static TransportPair getTransportPair(AdminServerSetting setting) throws KrbException {
        int udpPort;
        TransportPair result = new TransportPair();
        int tcpPort = setting.checkGetAdminTcpPort();
        if (tcpPort > 0) {
            result.tcpAddress = new InetSocketAddress(setting.getAdminHost(), tcpPort);
        }
        if ((udpPort = setting.checkGetAdminUdpPort()) > 0) {
            result.udpAddress = new InetSocketAddress(setting.getAdminHost(), udpPort);
        }
        return result;
    }

    public static String fixPrincipal(String principal, AdminServerSetting setting) {
        if (!principal.contains("@")) {
            principal = principal + "@" + setting.getKdcRealm();
        }
        return principal;
    }
}

