/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.admin.server.kadmin;

import java.io.File;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerConfig;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerOption;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerSetting;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.AdminServerUtil;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl.DefaultInternalAdminServerImpl;
import org.apache.kerby.kerberos.kerb.admin.server.kadmin.impl.InternalAdminServer;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendConfig;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.apache.kerby.kerberos.kerb.server.KdcConfig;

public class AdminServer {
    private final AdminServerConfig adminServerConfig;
    private final BackendConfig backendConfig;
    private final KdcConfig kdcConfig;
    private final AdminServerSetting adminServerSetting;
    private final KOptions startupOptions;
    private InternalAdminServer innerAdminServer;

    public AdminServer(AdminServerConfig adminServerConfig, BackendConfig backendConfig, KdcConfig kdcConfig) throws KrbException {
        this.adminServerConfig = adminServerConfig;
        this.kdcConfig = kdcConfig;
        this.backendConfig = backendConfig;
        this.startupOptions = new KOptions();
        this.adminServerSetting = new AdminServerSetting(this.startupOptions, adminServerConfig, kdcConfig, backendConfig);
    }

    public AdminServer(File confDir) throws KrbException {
        AdminServerConfig tmpAdminServerConfig = AdminServerUtil.getAdminServerConfig(confDir);
        if (tmpAdminServerConfig == null) {
            tmpAdminServerConfig = new AdminServerConfig();
        }
        this.adminServerConfig = tmpAdminServerConfig;
        KdcConfig tmpKdcConfig = AdminServerUtil.getKdcConfig(confDir);
        if (tmpKdcConfig == null) {
            tmpKdcConfig = new KdcConfig();
        }
        this.kdcConfig = tmpKdcConfig;
        BackendConfig tmpBackendConfig = AdminServerUtil.getBackendConfig(confDir);
        if (tmpBackendConfig == null) {
            tmpBackendConfig = new BackendConfig();
        }
        tmpBackendConfig.setConfDir(confDir);
        this.backendConfig = tmpBackendConfig;
        this.startupOptions = new KOptions();
        this.adminServerSetting = new AdminServerSetting(this.startupOptions, this.adminServerConfig, this.kdcConfig, this.backendConfig);
    }

    public AdminServer() {
        this.adminServerConfig = new AdminServerConfig();
        this.backendConfig = new BackendConfig();
        this.kdcConfig = new KdcConfig();
        this.startupOptions = new KOptions();
        this.adminServerSetting = new AdminServerSetting(this.startupOptions, this.adminServerConfig, this.kdcConfig, this.backendConfig);
    }

    public void setAdminServerRealm(String realm) {
        this.startupOptions.add((KOption)AdminServerOption.ADMIN_REALM, (Object)realm);
    }

    public void setAdminHost(String adminHost) {
        this.startupOptions.add((KOption)AdminServerOption.ADMIN_HOST, (Object)adminHost);
    }

    public void setAdminServerPort(int adminPort) {
        this.startupOptions.add((KOption)AdminServerOption.ADMIN_PORT, (Object)adminPort);
    }

    public void setAdminTcpPort(int adminTcpPort) {
        this.startupOptions.add((KOption)AdminServerOption.ADMIN_TCP_PORT, (Object)adminTcpPort);
    }

    public void setAllowUdp(boolean allowUdp) {
        this.startupOptions.add((KOption)AdminServerOption.ALLOW_UDP, (Object)allowUdp);
    }

    public void setAllowTcp(boolean allowTcp) {
        this.startupOptions.add((KOption)AdminServerOption.ALLOW_TCP, (Object)allowTcp);
    }

    public void setAdminUdpPort(int adminUdpPort) {
        this.startupOptions.add((KOption)AdminServerOption.ADMIN_UDP_PORT, (Object)adminUdpPort);
    }

    public void setWorkDir(File workDir) {
        this.startupOptions.add((KOption)AdminServerOption.WORK_DIR, (Object)workDir);
    }

    public void enableDebug() {
        this.startupOptions.add((KOption)AdminServerOption.ENABLE_DEBUG);
    }

    public void setInnerAdminServerImpl(InternalAdminServer innerAdminServerImpl) {
        this.startupOptions.add((KOption)AdminServerOption.INNER_ADMIN_IMPL, (Object)innerAdminServerImpl);
    }

    public AdminServerSetting getAdminServerSetting() {
        return this.adminServerSetting;
    }

    public AdminServerConfig getAdminServerConfig() {
        return this.adminServerConfig;
    }

    public BackendConfig getBackendConfig() {
        return this.backendConfig;
    }

    public IdentityBackend getIdentityService() {
        if (this.innerAdminServer == null) {
            throw new RuntimeException("Not init yet");
        }
        return this.innerAdminServer.getIdentityBackend();
    }

    public void init() throws KrbException {
        this.innerAdminServer = this.startupOptions.contains((KOption)AdminServerOption.INNER_ADMIN_IMPL) ? (InternalAdminServer)this.startupOptions.getOptionValue((KOption)AdminServerOption.INNER_ADMIN_IMPL) : new DefaultInternalAdminServerImpl(this.adminServerSetting);
        this.innerAdminServer.init();
    }

    public void start() throws KrbException {
        if (this.innerAdminServer == null) {
            throw new RuntimeException("Not init yet");
        }
        this.innerAdminServer.start();
    }

    public void stop() throws KrbException {
        if (this.innerAdminServer != null) {
            this.innerAdminServer.stop();
        }
    }
}

