/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.Kadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class RenamePrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: rename_principal [-force] old_principal new_principal\n";
    private KOptions kOptions;
    private String oldPrincipalName;
    private String newPrincipalName;

    public RenamePrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split("\\s+");
        if (commands.length < 3 || commands.length > 4) {
            System.err.println(USAGE);
            return;
        }
        this.kOptions = ToolUtil.parseOptions(commands, 1, commands.length - 3);
        if (this.kOptions == null) {
            System.err.println(USAGE);
            return;
        }
        this.oldPrincipalName = commands[commands.length - 2];
        this.newPrincipalName = commands[commands.length - 1];
        if (this.kOptions.contains((KOption)KadminOption.FORCE)) {
            this.renamePrincipal((Kadmin)this.getKadmin());
        } else {
            String prompt = "Are you sure want to rename the principal? (yes/no, YES/NO, y/n, Y/N) ";
            String reply = ToolUtil.getReplay(prompt);
            if (reply.equals("yes") || reply.equals("YES") || reply.equals("y") || reply.equals("Y")) {
                this.renamePrincipal((Kadmin)this.getKadmin());
            } else if (reply.equals("no") || reply.equals("NO") || reply.equals("n") || reply.equals("N")) {
                System.out.println("Principal \"" + this.oldPrincipalName + "\"  not renamed.");
            } else {
                System.err.println("Unknown response, fail to rename the principal.");
            }
        }
    }

    public void renamePrincipal(Kadmin kadmin) {
        try {
            kadmin.renamePrincipal(this.oldPrincipalName, this.newPrincipalName);
            System.out.println("Principal \"" + this.oldPrincipalName + "\" renamed to \"" + this.newPrincipalName + "\".");
        }
        catch (KrbException e) {
            System.err.println("Principal rename failed! Exception happened. " + e.getMessage());
        }
    }
}

