/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import org.apache.kerby.KOption;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class ModifyPrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: modify_principal [options] principal\n\toptions are:\n\t\t[-expire dd/MM/yy:HH:mm:ss]\n\t\t[-disabled true/false]\n\t\t[-locked true/false]\n\tExample:\n\t\tmodify_principal -expire 23/04/15:01:01:01 -disabled false -locked true test@EXAMPLE.COM";
    private KOptions kOptions = new KOptions();
    private String principal;

    public ModifyPrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split(" ");
        if (commands.length < 2) {
            ToolUtil.printUsage("missing operand!", USAGE);
            return;
        }
        this.parseOptions(commands);
        try {
            this.getKadmin().modifyPrincipal(this.principal, this.kOptions);
            System.out.println("Principal \"" + this.principal + "\" modified.");
        }
        catch (KrbException e) {
            System.err.println("Principal \"" + this.principal + "\" fail to modify. " + e.getMessage());
        }
    }

    private void parseOptions(String[] commands) {
        int i = 1;
        while (i < commands.length) {
            KadminOption kOption;
            String opt;
            String error = null;
            if ((opt = commands[i++]).startsWith("-")) {
                kOption = KadminOption.fromName((String)opt);
                if (kOption == KadminOption.NONE) {
                    error = "Invalid option:" + opt;
                    System.err.println(error);
                    break;
                }
            } else {
                this.principal = opt;
                kOption = KadminOption.NONE;
            }
            if (kOption.getOptionInfo().getType() != KOptionType.NOV) {
                String param = null;
                if (i < commands.length) {
                    param = commands[i++];
                }
                if (param != null) {
                    KOptions.parseSetValue((KOptionInfo)kOption.getOptionInfo(), (String)param);
                } else {
                    error = "Option " + opt + " require a parameter";
                }
            }
            if (error != null) {
                ToolUtil.printUsage(error, USAGE);
            }
            this.kOptions.add((KOption)kOption);
        }
        if (this.principal == null) {
            ToolUtil.printUsage("missing principal name!", USAGE);
        }
    }
}

