/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class ListPrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: list_principals [expression]\n\t'expression' is a shell-style glob expression that can contain the wild-card characters ?, *, and [].";

    public ListPrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split("\\s+");
        if (commands.length <= 2) {
            String expression = commands.length == 2 ? commands[1] : null;
            try {
                List principalNames = this.getKadmin().getPrincipals(expression);
                if (principalNames.size() == 0) {
                    return;
                }
                System.out.println("Principals are listed:");
                for (String principalName : principalNames) {
                    System.out.println("\t" + principalName);
                }
            }
            catch (KrbException e) {
                System.err.print("Fail to list principal! " + e.getMessage());
            }
        } else {
            System.err.println(USAGE);
        }
    }
}

