/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.io.File;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class KeytabRemoveCommand
extends KadminCommand {
    private static final String USAGE = "Usage: ktremove [-k[eytab] keytab] [-q] principal [kvno | all | old]";
    private static final String DEFAULT_KEYTAB_FILE = "/etc/krb5.keytab";

    public KeytabRemoveCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String keytabFileLocation;
        String principal;
        int lastIndex;
        String[] commands = input.split("\\s+");
        if (commands.length < 2 || commands.length > 6) {
            System.err.println(USAGE);
            return;
        }
        String removeOption = null;
        if (commands[commands.length - 1].matches("^all|old|-?\\d+$")) {
            if (commands.length < 3) {
                System.err.println(USAGE);
                return;
            }
            lastIndex = commands.length - 3;
            principal = commands[commands.length - 2];
            removeOption = commands[commands.length - 1];
        } else {
            lastIndex = commands.length - 2;
            principal = commands[commands.length - 1];
        }
        KOptions kOptions = ToolUtil.parseOptions(commands, 1, lastIndex);
        if (principal == null || kOptions == null || kOptions.contains((KOption)KadminOption.K) && kOptions.contains((KOption)KadminOption.KEYTAB)) {
            System.err.println(USAGE);
            return;
        }
        String string = keytabFileLocation = kOptions.contains((KOption)KadminOption.K) ? kOptions.getStringOption((KOption)KadminOption.K) : kOptions.getStringOption((KOption)KadminOption.KEYTAB);
        if (keytabFileLocation == null) {
            keytabFileLocation = DEFAULT_KEYTAB_FILE;
        }
        File keytabFile = new File(keytabFileLocation);
        try {
            if ("all".equals(removeOption)) {
                this.getKadmin().removeKeytabEntriesOf(keytabFile, principal);
            } else if ("old".equals(removeOption)) {
                this.getKadmin().removeOldKeytabEntriesOf(keytabFile, principal);
            } else {
                int kvno = Integer.parseInt(removeOption);
                this.getKadmin().removeKeytabEntriesOf(keytabFile, principal, kvno);
            }
            System.out.println("Done!");
        }
        catch (KrbException e) {
            System.err.println("Principal \"" + principal + "\" fail to remove entry from keytab." + e.getMessage());
        }
    }
}

