/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.util.Map;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.kerb.request.KrbIdentity;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class GetPrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: getprinc principalName\nsuch as, getprinc hello@TEST.COM";

    public GetPrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split(" ");
        if (commands.length != 2) {
            System.err.println(USAGE);
            return;
        }
        String princName = commands[commands.length - 1];
        KrbIdentity identity = null;
        try {
            identity = this.getKadmin().getPrincipal(princName);
        }
        catch (KrbException e) {
            System.err.println("Fail to get principal: " + princName + ". " + e.getMessage());
        }
        if (identity == null) {
            System.err.println(princName + " doesn't exist\n");
            System.err.println(USAGE);
            return;
        }
        Map key = identity.getKeys();
        System.out.println("Principal: " + identity.getPrincipalName() + "\nExpiration data: " + identity.getExpireTime() + "\nCreated time: " + identity.getCreatedTime() + "\nKDC flags: " + identity.getKdcFlags() + "\nKey version: " + identity.getKeyVersion() + "\nNumber of keys: " + key.size());
        for (EncryptionType keyType : key.keySet()) {
            System.out.println("key: " + keyType);
        }
    }
}

