/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.Kadmin;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class DeletePrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: delete_principal [options] principal\nThis command prompts for deletion, unless the -force option is given.\n\toptions are:\n\t\t[-force] no prompts for deletion.";
    private Boolean force = false;

    public DeletePrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split(" ");
        if (commands.length < 2) {
            System.err.println(USAGE);
            return;
        }
        this.parseOptions(commands);
        String principal = commands[commands.length - 1];
        if (this.force.booleanValue()) {
            this.deletePrincipal((Kadmin)this.getKadmin(), principal);
        } else {
            String reply;
            Console console = System.console();
            String prompt = "Are you sure want to delete the principal? (yes/no, YES/NO, y/n, Y/N) ";
            if (console == null) {
                System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
                Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
                reply = this.getReply(scanner, prompt);
            } else {
                reply = this.getReply(console, prompt);
            }
            if (reply.equals("yes") || reply.equals("YES") || reply.equals("y") || reply.equals("Y")) {
                this.deletePrincipal((Kadmin)this.getKadmin(), principal);
            } else if (reply.equals("no") || reply.equals("NO") || reply.equals("n") || reply.equals("N")) {
                System.out.println("Principal \"" + principal + "\"  not deleted.");
            } else {
                System.err.println("Unknow request, fail to delete the principal.");
            }
        }
    }

    private void deletePrincipal(Kadmin kadmin, String principal) {
        try {
            kadmin.deletePrincipal(principal);
            System.out.println("Principal \"" + principal + "\" deleted.");
        }
        catch (KrbException e) {
            System.err.println("Fail to delete principal \"" + principal + "\" ." + e.getMessage());
        }
    }

    private String getReply(Scanner scanner, String prompt) {
        System.out.println(prompt);
        return scanner.nextLine().trim();
    }

    private String getReply(Console console, String prompt) {
        console.printf(prompt, new Object[0]);
        String line = console.readLine();
        return line;
    }

    private void parseOptions(String[] commands) {
        if (commands[1].equals("-force")) {
            this.force = true;
        }
    }
}

