/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin.command;

import java.io.Console;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Scanner;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;
import org.apache.kerby.kerberos.kerb.admin.kadmin.local.LocalKadmin;
import org.apache.kerby.kerberos.tool.kadmin.ToolUtil;
import org.apache.kerby.kerberos.tool.kadmin.command.KadminCommand;

public class AddPrincipalCommand
extends KadminCommand {
    private static final String USAGE = "Usage: add_principal [options] principal\n\toptions are:\n\t\t[-randkey|-nokey] [-x db_princ_args]* [-expire expdate] [-pwexpire pwexpdate] [-maxlife maxtixlife]\n\t\t[-kvno kvno] [-policy policy] [-clearpolicy]\n\t\t[-pw password] [-maxrenewlife maxrenewlife]\n\t\t[-e keysaltlist]\n\t\t[{+|-}attribute]\n\tattributes are:\n\t\tallow_postdated allow_forwardable allow_tgs_req allow_renewable\n\t\tallow_proxiable allow_dup_skey allow_tix requires_preauth\n\t\trequires_hwauth needchange allow_svr password_changing_service\n\t\tok_as_delegate ok_to_auth_as_delegate no_auth_data_required\n\n\twhere,\n\t[-x db_princ_args]* - any number of database specific arguments.\n\t\t\tLook at each database documentation for supported arguments.\n\tExample:\n\t\tadd_principal -expire 23/04/15:01:01:01 -kvno 1 -pw mypassword test@EXAMPLE.COM";
    private KOptions kOptions;

    public AddPrincipalCommand(LocalKadmin kadmin) {
        super(kadmin);
    }

    @Override
    public void execute(String input) {
        String[] commands = input.split("\\s+");
        if (commands.length < 2) {
            System.err.println(USAGE);
            return;
        }
        this.kOptions = ToolUtil.parseOptions(commands, 1, commands.length - 2);
        if (this.kOptions == null) {
            System.err.println(USAGE);
            return;
        }
        String principal = commands[commands.length - 1];
        if (this.kOptions.contains((KOption)KadminOption.RANDKEY)) {
            try {
                this.getKadmin().addPrincipal(principal, this.kOptions);
            }
            catch (KrbException e) {
                System.err.println("Fail to add principal \"" + principal + "\"." + e.getMessage());
            }
        } else {
            String password = this.kOptions.contains((KOption)KadminOption.PW) ? this.kOptions.getStringOption((KOption)KadminOption.PW) : this.getPassword(principal);
            if (password == null) {
                return;
            }
            try {
                this.getKadmin().addPrincipal(principal, password, this.kOptions);
                System.out.println("Principal \"" + principal + "\" created.");
            }
            catch (KrbException e) {
                System.err.println("Fail to add principal \"" + principal + "\"." + e.getMessage());
            }
        }
    }

    private String getPassword(String principal) {
        String passwordTwice;
        String passwordOnce;
        Console console = System.console();
        if (console == null) {
            System.out.println("Couldn't get Console instance, maybe you're running this from within an IDE. Use scanner to read password.");
            Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
            passwordOnce = this.getPassword(scanner, "Enter password for principal \"" + principal + "\":");
            passwordTwice = this.getPassword(scanner, "Re-enter password for principal \"" + principal + "\":");
        } else {
            passwordOnce = this.getPassword(console, "Enter password for principal \"" + principal + "\":");
            passwordTwice = this.getPassword(console, "Re-enter password for principal \"" + principal + "\":");
        }
        if (!passwordOnce.equals(passwordTwice)) {
            System.err.println("add_principal: Password mismatch while reading password for \"" + principal + "\".");
            return null;
        }
        return passwordOnce;
    }

    private String getPassword(Scanner scanner, String prompt) {
        System.out.println(prompt);
        return scanner.nextLine().trim();
    }

    private String getPassword(Console console, String prompt) {
        console.printf(prompt, new Object[0]);
        char[] passwordChars = console.readPassword();
        String password = new String(passwordChars).trim();
        Arrays.fill(passwordChars, ' ');
        return password;
    }
}

