/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.tool.kadmin;

import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.apache.kerby.KOption;
import org.apache.kerby.KOptionInfo;
import org.apache.kerby.KOptionType;
import org.apache.kerby.KOptions;
import org.apache.kerby.kerberos.kerb.admin.kadmin.KadminOption;

public class ToolUtil {
    public static void printUsage(String error, String usage) {
        System.err.println(error + "\n");
        System.err.println(usage);
    }

    public static KOptions parseOptions(String[] commands, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            System.out.println("Invalid function parameter(s).");
            return null;
        }
        KOptions kOptions = new KOptions();
        int i = beginIndex;
        while (i <= endIndex) {
            KadminOption kOption;
            String opt;
            String error = null;
            if ((opt = commands[i++]).startsWith("-")) {
                kOption = KadminOption.fromName((String)opt);
                if (kOption == KadminOption.NONE) {
                    error = "Invalid option:" + opt;
                }
            } else {
                kOption = KadminOption.NONE;
                error = "Invalid parameter:" + opt + " , it does not belong to any option.";
            }
            if (kOption != KadminOption.NONE && kOption.getOptionInfo().getType() != KOptionType.NOV) {
                String param = null;
                if (i <= endIndex) {
                    param = commands[i++];
                }
                if (param != null) {
                    KOptions.parseSetValue((KOptionInfo)kOption.getOptionInfo(), (String)param);
                } else {
                    error = "Option " + opt + " require a parameter";
                }
            }
            if (error != null) {
                System.out.println(error);
                return null;
            }
            if (kOption == KadminOption.NONE) continue;
            kOptions.add((KOption)kOption);
        }
        return kOptions;
    }

    public static String getReplay(String prompt) {
        Scanner scanner = new Scanner(System.in, StandardCharsets.UTF_8.name());
        System.out.println(prompt);
        String str = scanner.nextLine().trim();
        return str;
    }
}

