/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.integration.test.sasl;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.apache.kerby.kerberos.kerb.integration.test.AppClient;
import org.apache.kerby.kerberos.kerb.integration.test.Transport;

public class SaslAppClient
extends AppClient {
    private SaslClient saslClient;

    public SaslAppClient(String[] args) throws Exception {
        super(args);
        String protocol = args[2];
        String serverFqdn = args[3];
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("javax.security.sasl.qop", "auth");
        this.saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, null, protocol, serverFqdn, props, null);
    }

    public static void main(String[] args) throws Exception {
        new SaslAppClient(args).run();
    }

    @Override
    protected void usage(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: SaslAppClient <server-host> <server-port> <service-protocol> <server-fqdn>");
            throw new RuntimeException("Usage: SaslAppClient <server-host> <server-port> <service-protocol> <server-fqdn>");
        }
    }

    @Override
    protected void withConnection(Transport.Connection conn) throws Exception {
        byte[] token = this.saslClient.hasInitialResponse() ? new byte[]{} : null;
        token = this.saslClient.evaluateChallenge(token);
        conn.sendMessage("CONT", token);
        Transport.Message msg = conn.recvMessage();
        while (!this.saslClient.isComplete() && (this.isContinue(msg) || this.isOK(msg))) {
            byte[] respToken = this.saslClient.evaluateChallenge(msg.body);
            if (this.isOK(msg)) {
                if (respToken == null) break;
                throw new IOException("Attempting to send response after completion");
            }
            conn.sendMessage("CONT", respToken);
            msg = conn.recvMessage();
        }
        token = "Hello There!\u0000".getBytes(StandardCharsets.UTF_8);
        conn.sendToken(token);
        this.setTestOK(true);
        this.saslClient.dispose();
    }

    private boolean isOK(Transport.Message msg) {
        if (msg.header != null) {
            return new String(msg.header, StandardCharsets.UTF_8).equals("OK");
        }
        return false;
    }

    private boolean isContinue(Transport.Message msg) {
        if (msg.header != null) {
            return new String(msg.header, StandardCharsets.UTF_8).equals("CONT");
        }
        return false;
    }
}

