/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.benchmark;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class KrbCodecBenchmark {
    private static final Logger LOG = LoggerFactory.getLogger(KrbCodecBenchmark.class);
    private static ByteBuffer apreqToken;

    @Benchmark
    @Fork(value=1)
    @Warmup(iterations=5)
    public void decodeWithKerby() throws Exception {
        ApReq apReq = new ApReq();
        apReq.decode(apreqToken.duplicate());
        String serverName = apReq.getTicket().getSname().toString();
        if (serverName == null) {
            throw new RuntimeException("Decoding test failed");
        }
    }

    static {
        try (InputStream is = KrbCodecBenchmark.class.getResourceAsStream("/apreq.token");){
            byte[] bytes = new byte[is.available()];
            is.read(bytes);
            apreqToken = ByteBuffer.wrap(bytes);
        }
        catch (IOException e) {
            LOG.error("Fail to read bytes from input stream. " + e);
        }
    }
}

