/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.benchmark;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.kerby.config.Conf;
import org.apache.kerby.config.Config;
import org.apache.kerby.kerberos.kdc.identitybackend.JsonIdentityBackend;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.identity.backend.BackendTestUtil;
import org.apache.kerby.kerberos.kerb.identity.backend.IdentityBackend;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Benchmark)
public class JsonBackendBenchmark {
    private IdentityBackend backend;
    private File jsonBackendFile;

    @Setup
    public void setup() throws KrbException {
        this.prepareBackend();
        this.prepareIdentities();
    }

    private void prepareBackend() throws KrbException {
        File testDir = new File(System.getProperty("test.dir", "target"));
        this.jsonBackendFile = new File(testDir, "json-identity-backend-file");
        String jsonBackendFileString = this.jsonBackendFile.getAbsolutePath();
        Conf backendConfig = new Conf();
        backendConfig.setString("backend.json.dir", jsonBackendFileString);
        this.backend = new JsonIdentityBackend((Config)backendConfig);
        this.backend.initialize();
    }

    private void prepareIdentities() throws KrbException {
        BackendTestUtil.createManyIdentities((IdentityBackend)this.backend, (int)100);
        BackendTestUtil.createTheTestIdentity((IdentityBackend)this.backend);
    }

    @Benchmark
    @Fork(value=1)
    public void queryTest() throws Exception {
        BackendTestUtil.getTheTestIdentity((IdentityBackend)this.backend);
    }

    @TearDown
    public void cleanup() throws KrbException {
        boolean delete;
        if (this.backend != null) {
            this.backend.stop();
            this.backend.release();
        }
        if (this.jsonBackendFile.exists() && !(delete = this.jsonBackendFile.delete())) {
            throw new RuntimeException("File delete error!");
        }
    }
}

