/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.features;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.ConfigFile;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.tooling.features.AbstractFeatureMojo;
import org.apache.karaf.tooling.features.CopyFileBasedDescriptor;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="features-add-to-repository", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class AddToRepositoryMojo
extends AbstractFeatureMojo {
    @Parameter(defaultValue="${project.build.directory}/features-repo")
    protected File repository;
    @Parameter
    private boolean flatRepoLayout;
    @Parameter
    protected List<CopyFileBasedDescriptor> copyFileBasedDescriptors;
    @Parameter(defaultValue="false")
    private boolean timestampedSnapshot;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<Feature> featuresSet = this.resolveFeatures();
        for (Artifact descriptor : this.descriptorArtifacts) {
            this.copy(descriptor, this.repository);
        }
        for (Feature feature : featuresSet) {
            this.copyBundlesToDestRepository(feature.getBundle());
            for (Conditional conditional : feature.getConditional()) {
                this.copyBundlesConditionalToDestRepository(conditional.getBundles());
            }
            this.copyConfigFilesToDestRepository(feature.getConfigfile());
        }
        this.copyFileBasedDescriptorsToDestRepository();
    }

    private void copyBundlesConditionalToDestRepository(List<? extends BundleInfo> artifactRefsConditional) throws MojoExecutionException {
        for (BundleInfo bundleInfo : artifactRefsConditional) {
            if (!this.ignoreDependencyFlag && (this.ignoreDependencyFlag || bundleInfo.isDependency())) continue;
            Artifact artifact = this.resourceToArtifact(bundleInfo.getLocation(), this.skipNonMavenProtocols);
            this.resolveArtifact(artifact, this.remoteRepos);
            if (artifact == null) continue;
            this.copy(artifact, this.repository);
        }
    }

    private void copyBundlesToDestRepository(List<? extends Bundle> artifactRefs) throws MojoExecutionException {
        for (Bundle bundle : artifactRefs) {
            Artifact artifact = this.resourceToArtifact(bundle.getLocation(), this.skipNonMavenProtocols);
            this.resolveArtifact(artifact, this.remoteRepos);
            if (artifact == null) continue;
            this.copy(artifact, this.repository);
        }
    }

    private void copyConfigFilesToDestRepository(List<? extends ConfigFile> artifactRefs) throws MojoExecutionException {
        for (ConfigFile configFile : artifactRefs) {
            Artifact artifact = this.resourceToArtifact(configFile.getLocation(), this.skipNonMavenProtocols);
            this.resolveArtifact(artifact, this.remoteRepos);
            if (artifact == null) continue;
            this.copy(artifact, this.repository);
        }
    }

    protected void copy(Artifact artifact, File destRepository) {
        try {
            this.getLog().info((CharSequence)("Copying artifact: " + String.valueOf(artifact)));
            File destFile = new File(destRepository, this.getRelativePath(artifact));
            if (artifact.getFile() == null) {
                throw new IllegalStateException("Artifact is not present in local repo.");
            }
            this.copy(artifact.getFile(), destFile);
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Error copying artifact " + String.valueOf(artifact)), (Throwable)e);
        }
    }

    private String getRelativePath(Artifact artifact) {
        String dir = this.flatRepoLayout ? "" : MavenUtil.getDir(artifact);
        String name = MavenUtil.getFileName(artifact, this.timestampedSnapshot);
        return dir + name;
    }

    private void copyFileBasedDescriptorsToDestRepository() {
        if (this.copyFileBasedDescriptors != null) {
            for (CopyFileBasedDescriptor fileBasedDescriptor : this.copyFileBasedDescriptors) {
                File destDir = new File(this.repository, fileBasedDescriptor.getTargetDirectory());
                File destFile = new File(destDir, fileBasedDescriptor.getTargetFileName());
                this.copy(fileBasedDescriptor.getSourceFile(), destFile);
            }
        }
    }
}

