/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.commands;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.tooling.commands.AsciiDoctorCommandHelpPrinter;
import org.apache.karaf.tooling.commands.CommandHelpPrinter;
import org.apache.karaf.tooling.commands.DocBookCommandHelpPrinter;
import org.apache.karaf.tooling.commands.FormatEnum;
import org.apache.karaf.tooling.commands.MarkdownCommandHelpPrinter;
import org.apache.karaf.tooling.commands.UserConfCommandHelpPrinter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;

@Mojo(name="commands-generate-help", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME, inheritByDefault=false, threadSafe=true)
public class GenerateHelpMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/docbkx/sources")
    protected File targetFolder;
    @Parameter(defaultValue="docbx")
    protected String format;
    @Parameter(defaultValue="project")
    protected String classLoader;
    @Parameter(defaultValue="true")
    protected boolean includeHelpOption;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            if (!this.targetFolder.exists()) {
                this.targetFolder.mkdirs();
            }
            FormatEnum formatEnum = FormatEnum.fromString(this.format);
            ClassFinder finder = this.createFinder(this.classLoader);
            List classes = finder.findAnnotatedClasses(Command.class);
            if (classes.isEmpty()) {
                throw new MojoFailureException("No command found");
            }
            CommandHelpPrinter helpPrinter = this.getPrinter(formatEnum);
            TreeMap<String, Set<String>> commands = new TreeMap<String, Set<String>>();
            String commandSuffix = formatEnum.fileSuffix;
            for (Class clazz : classes) {
                try {
                    Action action = (Action)clazz.newInstance();
                    Command cmd = clazz.getAnnotation(Command.class);
                    if (cmd.scope().equals("*")) continue;
                    File output = new File(this.targetFolder, cmd.scope() + "-" + cmd.name() + "." + commandSuffix);
                    try (FileOutputStream outStream = new FileOutputStream(output);
                         PrintStream out = new PrintStream(outStream);){
                        helpPrinter.printHelp(action, out, this.includeHelpOption);
                    }
                    commands.computeIfAbsent(cmd.scope(), k -> new TreeSet()).add(cmd.name());
                    this.getLog().info((CharSequence)("Found command: " + cmd.scope() + ":" + cmd.name()));
                }
                catch (Exception e) {
                    this.getLog().warn((CharSequence)("Unable to write help for " + clazz.getName()), (Throwable)e);
                }
            }
            String overViewSuffix = formatEnum.fileSuffix;
            PrintStream writer = new PrintStream(new FileOutputStream(new File(this.targetFolder, "commands." + overViewSuffix)));
            helpPrinter.printOverview(commands, writer);
            writer.close();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    private ClassFinder createFinder(String classloaderType) throws Exception {
        ClassFinder finder;
        if ("project".equals(classloaderType)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (Object object : this.project.getCompileClasspathElements()) {
                String path = (String)object;
                urls.add(new File(path).toURI().toURL());
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            finder = new ClassFinder((ClassLoader)loader, urls);
        } else if ("plugin".equals(this.classLoader)) {
            finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
        }
        return finder;
    }

    private CommandHelpPrinter getPrinter(FormatEnum format) {
        switch (format) {
            case CONF: {
                return new UserConfCommandHelpPrinter();
            }
            case ASCIIDOC: {
                return new AsciiDoctorCommandHelpPrinter();
            }
            case MARKDOWN: {
                return new MarkdownCommandHelpPrinter();
            }
        }
        return new DocBookCommandHelpPrinter();
    }
}

