/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.karaf.profile.assembly.Builder;
import org.apache.karaf.tooling.utils.IoUtils;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.karaf.tooling.utils.MojoSupport;
import org.apache.karaf.tooling.utils.ReactorMavenResolver;
import org.apache.karaf.tools.utils.model.KarafPropertyEdits;
import org.apache.karaf.tools.utils.model.io.stax.KarafPropertyInstructionsModelStaxReader;
import org.apache.karaf.util.Version;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.repository.WorkspaceReader;
import org.ops4j.pax.url.mvn.MavenResolver;

@Mojo(name="assembly", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.RUNTIME, threadSafe=true)
public class AssemblyMojo
extends MojoSupport {
    @Parameter(defaultValue="${project.basedir}/src/main/resources/assembly")
    protected File sourceDirectory;
    @Parameter(defaultValue="${project.build.directory}/assembly")
    protected File workDirectory;
    @Parameter
    protected File featuresProcessing;
    @Parameter(defaultValue="true")
    protected boolean installAllFeaturesByDefault = true;
    @Parameter
    private String environment;
    @Parameter
    protected int defaultStartLevel = 30;
    @Parameter
    private List<String> startupRepositories;
    @Parameter
    private List<String> bootRepositories;
    @Parameter
    private List<String> installedRepositories;
    @Parameter
    private List<String> blacklistedRepositories;
    @Parameter
    private List<String> startupFeatures;
    @Parameter
    private List<String> bootFeatures;
    @Parameter
    private List<String> installedFeatures;
    @Parameter
    private List<String> blacklistedFeatures;
    @Parameter
    private List<String> startupBundles;
    @Parameter
    private List<String> bootBundles;
    @Parameter
    private List<String> installedBundles;
    @Parameter
    private List<String> blacklistedBundles;
    @Parameter
    private List<String> profilesUris;
    @Parameter
    private List<String> startupProfiles;
    @Parameter
    private List<String> bootProfiles;
    @Parameter
    private List<String> installedProfiles;
    @Parameter
    private List<String> blacklistedProfiles;
    @Parameter(defaultValue="false")
    private boolean writeProfiles;
    @Parameter
    private String generateConsistencyReport;
    @Parameter(defaultValue="Apache Karaf")
    private String consistencyReportProjectName;
    @Parameter(defaultValue="${project.version}")
    private String consistencyReportProjectVersion;
    private List<String> startupKars = new ArrayList<String>();
    private List<String> bootKars = new ArrayList<String>();
    private List<String> installedKars = new ArrayList<String>();
    @Parameter
    private Builder.BlacklistPolicy blacklistPolicy = Builder.BlacklistPolicy.Discard;
    @Parameter(defaultValue="false")
    protected boolean ignoreDependencyFlag;
    @Parameter
    protected List<String> libraries;
    @Parameter(defaultValue="false")
    protected boolean useReferenceUrls;
    @Parameter(defaultValue="true")
    protected boolean includeBuildOutputDirectory;
    @Parameter
    protected Builder.KarafVersion karafVersion = Builder.KarafVersion.v4x;
    @Parameter(defaultValue="1.8")
    protected String javase;
    @Parameter
    protected String framework;
    @Parameter(defaultValue="${project.basedir}/src/main/karaf/assembly-property-edits.xml")
    protected String propertyFileEdits;
    @Parameter
    protected List<String> pidsToExtract = Collections.singletonList("*");
    @Parameter
    protected Map<String, String> translatedUrls;
    @Parameter
    protected Map<String, String> config;
    @Parameter
    protected Map<String, String> system;
    @Component(role=WorkspaceReader.class, hint="reactor")
    protected WorkspaceReader reactor;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.setNullListsToEmpty();
            this.setNullMapsToEmpty();
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to build assembly", e);
        }
    }

    protected void doExecute() throws Exception {
        File[] files;
        if (!(this.startupProfiles.isEmpty() && this.bootProfiles.isEmpty() && this.installedProfiles.isEmpty() || this.profilesUris.size() != 0)) {
            throw new IllegalArgumentException("profilesUris option must be specified");
        }
        Builder builder = Builder.newInstance();
        builder.offline(this.mavenSession.isOffline());
        builder.localRepository(this.localRepo.getBasedir());
        builder.resolverWrapper(resolver -> new ReactorMavenResolver(this.reactor, (MavenResolver)resolver));
        builder.javase(this.javase);
        builder.karafVersion(this.karafVersion);
        builder.useReferenceUrls(this.useReferenceUrls);
        builder.defaultAddAll(this.installAllFeaturesByDefault);
        builder.ignoreDependencyFlag(this.ignoreDependencyFlag);
        builder.propertyEdits(this.configurePropertyEdits());
        builder.translatedUrls(this.configureTranslatedUrls());
        builder.pidsToExtract(this.pidsToExtract);
        builder.writeProfiles(this.writeProfiles);
        builder.generateConsistencyReport(this.generateConsistencyReport);
        builder.setConsistencyReportProjectName(this.consistencyReportProjectName);
        builder.setConsistencyReportProjectVersion(this.consistencyReportProjectVersion);
        builder.environment(this.environment);
        builder.defaultStartLevel(this.defaultStartLevel);
        if (this.featuresProcessing != null) {
            builder.setFeaturesProcessing(this.featuresProcessing.toPath());
        }
        String remoteRepositories = MavenUtil.remoteRepositoryList(this.project.getRemoteProjectRepositories());
        this.getLog().info((CharSequence)"Using repositories:");
        for (String r : remoteRepositories.split(",")) {
            this.getLog().info((CharSequence)("   " + r));
        }
        builder.mavenRepositories(remoteRepositories);
        this.config.forEach((arg_0, arg_1) -> ((Builder)builder).config(arg_0, arg_1));
        this.system.forEach((arg_0, arg_1) -> ((Builder)builder).system(arg_0, arg_1));
        builder.blacklistBundles(this.blacklistedBundles);
        builder.blacklistFeatures(this.blacklistedFeatures);
        builder.blacklistProfiles(this.blacklistedProfiles);
        builder.blacklistRepositories(this.blacklistedRepositories);
        builder.blacklistPolicy(this.blacklistPolicy);
        this.configureWorkDirectory();
        this.getLog().info((CharSequence)("Creating work directory: " + this.workDirectory));
        builder.homeDirectory(this.workDirectory.toPath());
        this.getLog().info((CharSequence)"Loading direct KAR and features XML dependencies");
        this.processDirectMavenDependencies();
        this.profilesUris.forEach(xva$0 -> builder.profilesUris(new String[]{xva$0}));
        this.libraries.forEach(xva$0 -> builder.libraries(new String[]{xva$0}));
        this.detectStartupKarsAndFeatures(builder);
        builder.defaultStage(Builder.Stage.Startup).kars(this.toArray(this.startupKars)).repositories(this.startupFeatures.isEmpty() && this.startupProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.startupRepositories)).features(this.toArray(this.startupFeatures)).bundles(this.toArray(this.startupBundles)).profiles(this.toArray(this.startupProfiles));
        builder.defaultStage(Builder.Stage.Boot).kars(this.toArray(this.bootKars)).repositories(this.bootFeatures.isEmpty() && this.bootProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.bootRepositories)).features(this.toArray(this.bootFeatures)).bundles(this.toArray(this.bootBundles)).profiles(this.toArray(this.bootProfiles));
        builder.defaultStage(Builder.Stage.Installed).kars(this.toArray(this.installedKars)).repositories(this.installedFeatures.isEmpty() && this.installedProfiles.isEmpty() && this.installAllFeaturesByDefault, this.toArray(this.installedRepositories)).features(this.toArray(this.installedFeatures)).bundles(this.toArray(this.installedBundles)).profiles(this.toArray(this.installedProfiles));
        builder.generateAssembly();
        if (this.includeBuildOutputDirectory) {
            IoUtils.copyDirectory(new File(this.project.getBuild().getOutputDirectory()), this.workDirectory);
        }
        if (this.sourceDirectory.exists()) {
            IoUtils.copyDirectory(this.sourceDirectory, this.workDirectory);
        }
        if ((files = new File(this.workDirectory, "bin").listFiles()) != null) {
            for (File file : files) {
                if (file.getName().endsWith(".bat")) continue;
                try {
                    Files.setPosixFilePermissions(file.toPath(), PosixFilePermissions.fromString("rwxr-xr-x"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void configureWorkDirectory() {
        IoUtils.deleteRecursive(this.workDirectory);
        this.workDirectory.mkdirs();
        new File(this.workDirectory, "etc").mkdirs();
        new File(this.workDirectory, "system").mkdirs();
    }

    private void processDirectMavenDependencies() {
        for (Artifact artifact : this.project.getDependencyArtifacts()) {
            Builder.Stage stage = Builder.Stage.fromMavenScope((String)artifact.getScope());
            if (stage == null) continue;
            String uri = this.artifactToMvn(artifact);
            switch (this.getType(artifact)) {
                case "kar": {
                    this.addUris(stage, uri, this.startupKars, this.bootKars, this.installedKars);
                    break;
                }
                case "features": {
                    this.addUris(stage, uri, this.startupRepositories, this.bootRepositories, this.installedRepositories);
                    break;
                }
                case "bundle": {
                    this.addUris(stage, uri, this.startupBundles, this.bootBundles, this.installedBundles);
                }
            }
        }
    }

    private void addUris(Builder.Stage stage, String uri, List<String> startup, List<String> boot, List<String> installed) {
        switch (stage) {
            case Startup: {
                startup.add(uri);
                break;
            }
            case Boot: {
                boot.add(uri);
                break;
            }
            case Installed: {
                installed.add(uri);
            }
        }
    }

    private void detectStartupKarsAndFeatures(Builder builder) {
        String kar;
        boolean hasStandardKarafFrameworkKar = false;
        boolean hasCustomFrameworkKar = false;
        Iterator<String> iterator = this.startupKars.iterator();
        while (iterator.hasNext()) {
            kar = iterator.next();
            if (!kar.startsWith("mvn:org.apache.karaf.features/framework/") && !kar.startsWith("mvn:org.apache.karaf.features/static/")) continue;
            hasStandardKarafFrameworkKar = true;
            iterator.remove();
            if (this.framework == null) {
                this.framework = kar.startsWith("mvn:org.apache.karaf.features/framework/") ? "framework" : "static-framework";
            }
            this.getLog().info((CharSequence)("   Standard startup Karaf KAR found: " + kar));
            builder.kars(Builder.Stage.Startup, false, new String[]{kar});
            break;
        }
        if (!hasStandardKarafFrameworkKar) {
            if ("custom".equals(this.framework)) {
                if (this.startupKars.isEmpty()) {
                    throw new IllegalArgumentException("Custom KAR was declared, but there's no Maven dependency with type=kar and scope=compile. Please specify at least one KAR for custom assembly.");
                }
                if (this.startupFeatures.isEmpty()) {
                    throw new IllegalArgumentException("Custom KAR was declared, but there's no startup feature declared. Please specify at least one startup feature defined in features XML repository inside custom startup KAR or startup repository.");
                }
                hasCustomFrameworkKar = true;
                for (String startupKar : this.startupKars) {
                    this.getLog().info((CharSequence)("   Custom startup KAR found: " + startupKar));
                }
            } else {
                if (this.framework == null) {
                    throw new IllegalArgumentException("Can't determine framework to use (framework, framework-logback, static-framework, static-framework-logback, custom). Please specify valid \"framework\" option or add Maven dependency with \"kar\" type and \"compile\" scope for one of standard Karaf KARs.");
                }
                String realKarafVersion = Version.karafVersion();
                switch (this.framework) {
                    case "framework": 
                    case "framework-logback": {
                        kar = "mvn:org.apache.karaf.features/framework/" + realKarafVersion + "/kar";
                        break;
                    }
                    case "static-framework": 
                    case "static-framework-logback": {
                        kar = "mvn:org.apache.karaf.features/static/" + realKarafVersion + "/kar";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported framework: " + this.framework);
                    }
                }
                this.getLog().info((CharSequence)("   Standard startup KAR implied from framework (" + this.framework + "): " + kar));
                builder.kars(Builder.Stage.Startup, false, new String[]{kar});
            }
        }
        if (hasStandardKarafFrameworkKar && !this.startupFeatures.contains(this.framework)) {
            this.getLog().info((CharSequence)("   Feature " + this.framework + " will be added as a startup feature"));
            builder.features(Builder.Stage.Startup, new String[]{this.framework});
        }
    }

    private KarafPropertyEdits configurePropertyEdits() throws IOException, XMLStreamException {
        File file;
        KarafPropertyEdits edits = null;
        if (this.propertyFileEdits != null && (file = new File(this.propertyFileEdits)).exists()) {
            try (FileInputStream editsStream = new FileInputStream(this.propertyFileEdits);){
                KarafPropertyInstructionsModelStaxReader kipmsr = new KarafPropertyInstructionsModelStaxReader();
                edits = kipmsr.read((InputStream)editsStream, true);
            }
        }
        return edits;
    }

    private Map<String, String> configureTranslatedUrls() {
        HashMap<String, String> urls = new HashMap<String, String>();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>(this.project.getAttachedArtifacts());
        artifacts.add(this.project.getArtifact());
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !artifact.getFile().exists()) continue;
            String mvnUrl = this.artifactToMvn(artifact);
            urls.put(mvnUrl, artifact.getFile().toURI().toString());
        }
        urls.putAll(this.translatedUrls);
        return urls;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getType(Artifact artifact) {
        Throwable throwable;
        if ("kar".equals(artifact.getType())) {
            return "kar";
        }
        if ("zip".equals(artifact.getType())) {
            try {
                throwable = null;
                try (ZipFile zip222 = new ZipFile(artifact.getFile());){
                    if (zip222.getEntry("META-INF/KARAF.MF") != null) {
                        String string3 = "kar";
                        return string3;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (IOException zip222) {
                // empty catch block
            }
        }
        if ("features".equals(artifact.getClassifier())) {
            return "features";
        }
        if ("xml".equals(artifact.getType())) {
            try {
                throwable = null;
                try (FileInputStream is222 = new FileInputStream(artifact.getFile());){
                    XMLInputFactory xif = XMLInputFactory.newFactory();
                    xif.setProperty("javax.xml.stream.isNamespaceAware", true);
                    XMLStreamReader r = xif.createXMLStreamReader(is222);
                    r.nextTag();
                    QName name = r.getName();
                    if (name.getLocalPart().equals("features") && (name.getNamespaceURI().isEmpty() || name.getNamespaceURI().startsWith("http://karaf.apache.org/xmlns/features/"))) {
                        String string2 = "features";
                        return string2;
                    }
                }
                catch (Throwable xif) {
                    throwable = xif;
                    throw xif;
                }
            }
            catch (Exception is222) {
                // empty catch block
            }
        }
        if ("bundle".equals(artifact.getType())) {
            return "bundle";
        }
        if (!"jar".equals(artifact.getType())) return "unknown";
        try {
            throwable = null;
            try (JarFile jar = new JarFile(artifact.getFile());){
                Manifest manifest = jar.getManifest();
                if (manifest == null) return "unknown";
                if (manifest.getMainAttributes().getValue("Bundle-SymbolicName") == null) return "unknown";
                String string = "bundle";
                return string;
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "unknown";
    }

    private String artifactToMvn(Artifact artifact) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getBaseVersion();
        String type = artifact.getArtifactHandler().getExtension();
        String classifier = artifact.getClassifier();
        String uri = MavenUtil.isEmpty(classifier) ? ("jar".equals(type) ? String.format("mvn:%s/%s/%s", groupId, artifactId, version) : String.format("mvn:%s/%s/%s/%s", groupId, artifactId, version, type)) : String.format("mvn:%s/%s/%s/%s/%s", groupId, artifactId, version, type, classifier);
        return uri;
    }

    private String[] toArray(List<String> strings) {
        return strings.toArray(new String[strings.size()]);
    }

    private void setNullListsToEmpty() {
        this.startupRepositories = this.nonNullList(this.startupRepositories);
        this.bootRepositories = this.nonNullList(this.bootRepositories);
        this.installedRepositories = this.nonNullList(this.installedRepositories);
        this.blacklistedRepositories = this.nonNullList(this.blacklistedRepositories);
        this.startupBundles = this.nonNullList(this.startupBundles);
        this.bootBundles = this.nonNullList(this.bootBundles);
        this.installedBundles = this.nonNullList(this.installedBundles);
        this.blacklistedBundles = this.nonNullList(this.blacklistedBundles);
        this.startupFeatures = this.nonNullList(this.startupFeatures);
        this.bootFeatures = this.nonNullList(this.bootFeatures);
        this.installedFeatures = this.nonNullList(this.installedFeatures);
        this.blacklistedFeatures = this.nonNullList(this.blacklistedFeatures);
        this.startupProfiles = this.nonNullList(this.startupProfiles);
        this.bootProfiles = this.nonNullList(this.bootProfiles);
        this.installedProfiles = this.nonNullList(this.installedProfiles);
        this.blacklistedProfiles = this.nonNullList(this.blacklistedProfiles);
        this.libraries = this.nonNullList(this.libraries);
        this.profilesUris = this.nonNullList(this.profilesUris);
    }

    private void setNullMapsToEmpty() {
        this.config = this.nonNullMap(this.config);
        this.system = this.nonNullMap(this.system);
        this.translatedUrls = this.nonNullMap(this.translatedUrls);
    }

    private List<String> nonNullList(List<String> list) {
        ArrayList nonNullList = list == null ? new ArrayList() : list;
        return nonNullList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private Map<String, String> nonNullMap(Map<String, String> map) {
        return map == null ? new LinkedHashMap() : map;
    }
}

