/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.utils;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.tooling.utils.DependencyHelper;
import org.apache.karaf.tooling.utils.MavenUtil;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.collection.DependencyGraphTransformer;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.util.DefaultRepositorySystemSession;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.graph.selector.AndDependencySelector;
import org.sonatype.aether.util.graph.selector.ExclusionDependencySelector;
import org.sonatype.aether.util.graph.selector.OptionalDependencySelector;
import org.sonatype.aether.util.graph.transformer.ChainedDependencyGraphTransformer;
import org.sonatype.aether.util.graph.transformer.ConflictMarker;
import org.sonatype.aether.util.graph.transformer.JavaDependencyContextRefiner;
import org.sonatype.aether.util.graph.transformer.JavaEffectiveScopeCalculator;

public class Dependency30Helper
implements DependencyHelper {
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession repositorySystemSession;
    private final List<RemoteRepository> projectRepositories;
    protected Map<Artifact, String> localDependencies;
    protected String treeListing;

    public Dependency30Helper(List<RemoteRepository> projectRepositories, RepositorySystemSession repositorySystemSession, RepositorySystem repositorySystem) {
        this.projectRepositories = projectRepositories;
        this.repositorySystemSession = repositorySystemSession;
        this.repositorySystem = repositorySystem;
    }

    public Map<Artifact, String> getLocalDependencies() {
        return this.localDependencies;
    }

    @Override
    public String getTreeListing() {
        return this.treeListing;
    }

    @Override
    public void getDependencies(MavenProject project, boolean useTransitiveDependencies) throws MojoExecutionException {
        DependencyNode rootNode = this.getDependencyTree(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)project.getArtifact()));
        Scanner scanner = new Scanner();
        scanner.scan(rootNode, useTransitiveDependencies);
        this.localDependencies = scanner.localDependencies;
        this.treeListing = scanner.getLog();
    }

    private DependencyNode getDependencyTree(Artifact artifact) throws MojoExecutionException {
        try {
            CollectRequest collectRequest = new CollectRequest(new Dependency(artifact, "compile"), null, this.projectRepositories);
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.repositorySystemSession);
            session.setDependencySelector((DependencySelector)new AndDependencySelector(new DependencySelector[]{new OptionalDependencySelector(), new ScopeDependencySelector1(), new ExclusionDependencySelector()}));
            ChainedDependencyGraphTransformer transformer = new ChainedDependencyGraphTransformer(new DependencyGraphTransformer[]{new ConflictMarker(), new JavaEffectiveScopeCalculator(), new JavaDependencyContextRefiner()});
            session.setDependencyGraphTransformer((DependencyGraphTransformer)transformer);
            CollectResult result = this.repositorySystem.collectDependencies((RepositorySystemSession)session, collectRequest);
            return result.getRoot();
        }
        catch (DependencyCollectionException e) {
            throw new MojoExecutionException("Cannot build project dependency tree", (Exception)((Object)e));
        }
    }

    public static boolean isFeature(DependencyNode dependencyNode) {
        return Dependency30Helper.isFeature(dependencyNode.getDependency().getArtifact());
    }

    public static boolean isFeature(Artifact artifact) {
        return artifact.getExtension().equals("kar") || "features".equals(artifact.getClassifier());
    }

    @Override
    public boolean isArtifactAFeature(Object artifact) {
        return Dependency30Helper.isFeature((Artifact)artifact);
    }

    @Override
    public String getArtifactId(Object artifact) {
        return ((Artifact)artifact).getArtifactId();
    }

    @Override
    public String getClassifier(Object artifact) {
        return ((Artifact)artifact).getClassifier();
    }

    @Override
    public File resolve(Object artifact, Log log) {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.projectRepositories);
        log.debug((CharSequence)("Resolving artifact " + artifact + " from " + this.projectRepositories));
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
        }
        catch (ArtifactResolutionException e) {
            log.warn((CharSequence)("Could not resolve " + artifact), (Throwable)e);
            return null;
        }
        log.debug((CharSequence)("Resolved artifact " + artifact + " to " + result.getArtifact().getFile() + " from " + result.getRepository()));
        return result.getArtifact().getFile();
    }

    @Override
    public File resolveById(String id, Log log) throws MojoFailureException {
        ArtifactResult result;
        if (id.startsWith("mvn:")) {
            if (id.contains("!")) {
                id = id.substring(0, "mvn:".length()) + id.substring(id.indexOf("!") + 1);
            }
            if (id.endsWith("/")) {
                id = id.substring(0, id.length() - 1);
            }
        }
        id = MavenUtil.mvnToAether(id);
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact((Artifact)new DefaultArtifact(id));
        request.setRepositories(this.projectRepositories);
        log.debug((CharSequence)("Resolving artifact " + id + " from " + this.projectRepositories));
        try {
            result = this.repositorySystem.resolveArtifact(this.repositorySystemSession, request);
        }
        catch (ArtifactResolutionException e) {
            log.warn((CharSequence)("Could not resolve " + id), (Throwable)e);
            throw new MojoFailureException(String.format("Couldn't resolve artifact %s", id), (Throwable)e);
        }
        log.debug((CharSequence)("Resolved artifact " + id + " to " + result.getArtifact().getFile() + " from " + result.getRepository()));
        return result.getArtifact().getFile();
    }

    @Override
    public String artifactToMvn(org.apache.maven.artifact.Artifact artifact) {
        return this.artifactToMvn(RepositoryUtils.toArtifact((org.apache.maven.artifact.Artifact)artifact));
    }

    @Override
    public String artifactToMvn(Object _artifact) {
        Artifact artifact = (Artifact)_artifact;
        String bundleName = artifact.getExtension().equals("jar") && MavenUtil.isEmpty(artifact.getClassifier()) ? String.format("mvn:%s/%s/%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion()) : (MavenUtil.isEmpty(artifact.getClassifier()) ? String.format("mvn:%s/%s/%s/%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getExtension()) : String.format("mvn:%s/%s/%s/%s/%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion(), artifact.getExtension(), artifact.getClassifier()));
        return bundleName;
    }

    @Override
    public org.apache.maven.artifact.Artifact mvnToArtifact(String name) {
        name = MavenUtil.mvnToAether(name);
        DefaultArtifact artifact = new DefaultArtifact(name);
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        return mavenArtifact;
    }

    @Override
    public String pathFromMaven(String name) {
        if (name.indexOf(58) == -1) {
            return name;
        }
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        name = MavenUtil.mvnToAether(name);
        return this.pathFromAether(name);
    }

    @Override
    public String pathFromAether(String name) {
        DefaultArtifact artifact = new DefaultArtifact(name);
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)artifact);
        return MavenUtil.layout.pathOf(mavenArtifact);
    }

    private static class Scanner {
        private final Map<Artifact, String> localDependencies = new LinkedHashMap<Artifact, String>();
        private final Set<Artifact> dependencies = new LinkedHashSet<Artifact>();
        private final StringBuilder log = new StringBuilder();

        private Scanner() {
        }

        public void scan(DependencyNode rootNode, boolean useTransitiveDependencies) throws MojoExecutionException {
            for (DependencyNode child : rootNode.getChildren()) {
                this.scan(child, Accept.ACCEPT, useTransitiveDependencies, false, "");
            }
            if (useTransitiveDependencies) {
                this.localDependencies.keySet().removeAll(this.dependencies);
            }
        }

        private void scan(DependencyNode dependencyNode, Accept parentAccept, boolean useTransitiveDependencies, boolean isFromFeature, String indent) throws MojoExecutionException {
            Accept accept = this.accept(dependencyNode, parentAccept);
            if (accept.isLocal()) {
                if (isFromFeature) {
                    if (!Dependency30Helper.isFeature(dependencyNode)) {
                        this.log.append(indent).append("from feature: ").append(dependencyNode).append("\n");
                        this.dependencies.add(dependencyNode.getDependency().getArtifact());
                    } else {
                        this.log.append(indent).append("is feature: ").append(dependencyNode).append("\n");
                    }
                } else {
                    this.log.append(indent).append("local: ").append(dependencyNode).append("\n");
                    if (this.localDependencies.containsKey(dependencyNode.getDependency().getArtifact())) {
                        this.log.append(indent).append("already in feature, returning:").append(dependencyNode).append("\n");
                        return;
                    }
                    this.localDependencies.put(dependencyNode.getDependency().getArtifact(), dependencyNode.getDependency().getScope());
                    if (Dependency30Helper.isFeature(dependencyNode) || !useTransitiveDependencies) {
                        isFromFeature = true;
                    }
                }
                if (useTransitiveDependencies && accept.isContinue()) {
                    List children = dependencyNode.getChildren();
                    for (DependencyNode child : children) {
                        this.scan(child, accept, useTransitiveDependencies, isFromFeature, indent + " ");
                    }
                }
            }
        }

        public String getLog() {
            return this.log.toString();
        }

        private Accept accept(DependencyNode dependency, Accept previous) {
            String scope = dependency.getDependency().getScope();
            if (scope == null || "runtime".equalsIgnoreCase(scope) || "compile".equalsIgnoreCase(scope)) {
                return previous;
            }
            if ("provided".equalsIgnoreCase(scope)) {
                return Accept.PROVIDED;
            }
            return Accept.STOP;
        }

        private static enum Accept {
            ACCEPT(true, true),
            PROVIDED(true, false),
            STOP(false, false);

            private final boolean more;
            private final boolean local;

            private Accept(boolean more, boolean local) {
                this.more = more;
                this.local = local;
            }

            public boolean isContinue() {
                return this.more;
            }

            public boolean isLocal() {
                return this.local;
            }
        }
    }

    private static class ScopeDependencySelector3
    implements DependencySelector {
        private ScopeDependencySelector3() {
        }

        public boolean selectDependency(Dependency dependency) {
            String scope = dependency.getScope();
            return !"test".equals(scope) && !"provided".equals(scope) && !"runtime".equals(scope);
        }

        public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
            return this;
        }
    }

    private static class ScopeDependencySelector2
    implements DependencySelector {
        private DependencySelector child = new ScopeDependencySelector3();

        private ScopeDependencySelector2() {
        }

        public boolean selectDependency(Dependency dependency) {
            String scope = dependency.getScope();
            return !"test".equals(scope) && !"runtime".equals(scope);
        }

        public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
            return this.child;
        }
    }

    private static class ScopeDependencySelector1
    implements DependencySelector {
        private DependencySelector child = new ScopeDependencySelector2();

        private ScopeDependencySelector1() {
        }

        public boolean selectDependency(Dependency dependency) {
            throw new IllegalStateException("This does not appear to be called");
        }

        public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
            return this.child;
        }
    }
}

