/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.websocket;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Servlet;
import org.apache.karaf.examples.websocket.WebsocketExampleServlet;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.http.HttpService;

@WebSocket
@Component(name="example-websocket", immediate=true)
public class WebSocketExample {
    private static final Set<Session> sessions = Collections.synchronizedSet(new HashSet());
    private boolean notification = false;
    @Reference
    private HttpService httpService;

    @OnWebSocketConnect
    public void onOpen(Session session) {
        session.setIdleTimeout(-1L);
        sessions.add(session);
    }

    @OnWebSocketClose
    public void onClose(Session session, int statusCode, String reason) {
        sessions.remove(session);
    }

    @Activate
    public void activate() throws Exception {
        this.httpService.registerServlet("/example-websocket", (Servlet)new WebsocketExampleServlet(), null, null);
        this.notification = true;
        Thread notification = new Thread(new NotificationThread(sessions));
        notification.start();
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.httpService.unregister("/example-websocket");
        this.notification = false;
    }

    class NotificationThread
    implements Runnable {
        private Set<Session> sessions;

        public NotificationThread(Set<Session> sessions) {
            this.sessions = sessions;
        }

        @Override
        public void run() {
            try {
                while (WebSocketExample.this.notification) {
                    for (Session session : this.sessions) {
                        session.getRemote().sendString("Hello World");
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

