/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.soap.client;

import org.apache.karaf.examples.soap.api.Booking;
import org.apache.karaf.examples.soap.client.CxfClient;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Service
@Command(scope="booking", name="list", description="List bookings")
public class ListCommand
implements Action {
    @Option(name="--url", description="Location of the SOAP service", required=false, multiValued=false)
    String url = "http://localhost:8181/cxf/example";

    public Object execute() throws Exception {
        CxfClient client = new CxfClient(this.url);
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("Customer");
        table.column("Flight");
        if (client.list() != null) {
            for (Booking booking : client.list()) {
                table.addRow().addContent(new Object[]{booking.getId(), booking.getCustomer(), booking.getFlight()});
            }
        }
        table.print(System.out);
        return null;
    }
}

