/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.rest.client.cxf;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import java.util.ArrayList;
import java.util.List;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.karaf.examples.rest.api.Booking;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Service
@Command(scope="booking", name="list", description="List booking")
public class ListBookingCommand
implements Action {
    @Option(name="--url", description="Location of the REST service", required=false, multiValued=false)
    String restLocation = "http://localhost:8181/cxf/booking/";

    public Object execute() throws Exception {
        ArrayList<JacksonJsonProvider> providers = new ArrayList<JacksonJsonProvider>();
        providers.add(new JacksonJsonProvider());
        WebClient webClient = WebClient.create((String)this.restLocation, providers);
        List bookings = (List)webClient.accept(new String[]{"application/json"}).getCollection(Booking.class);
        for (Booking booking : bookings) {
            System.out.println(booking.getId() + " " + booking.getCustomer() + " " + booking.getFlight());
        }
        return null;
    }
}

