/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.redis.service;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.karaf.examples.redis.api.Booking;
import org.apache.karaf.examples.redis.api.BookingService;
import org.apache.karaf.examples.redis.service.RedisConfig;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import redis.clients.jedis.Jedis;

@Component(service={BookingService.class})
public class BookingServiceImpl
implements BookingService {
    private Jedis jedis;
    private String bookingListName;

    @Activate
    public void activate(RedisConfig config) {
        this.jedis = new Jedis(config.host());
        this.bookingListName = config.bookingListName();
    }

    @Deactivate
    public void deactivate() {
        this.jedis.close();
    }

    public List<Booking> list() {
        ArrayList<Booking> bookings = new ArrayList<Booking>();
        int i = 0;
        while ((long)i < this.jedis.llen(this.bookingListName)) {
            Booking booking = new GsonBuilder().create().fromJson(this.jedis.lindex(this.bookingListName, (long)i), Booking.class);
            bookings.add(booking);
            ++i;
        }
        return bookings;
    }

    public void add(Booking booking) {
        this.jedis.lpush(this.bookingListName, new GsonBuilder().create().toJson((Object)booking, (Type)((Object)Booking.class)));
    }
}

