/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.resps;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import redis.clients.jedis.Builder;
import redis.clients.jedis.BuilderFactory;

public class LibraryInfo {
    private final String libraryName;
    private final String engine;
    private final List<Map<String, Object>> functions;
    private final String libraryCode;
    public static final Builder<LibraryInfo> LIBRARY_BUILDER = new Builder<LibraryInfo>(){

        @Override
        public LibraryInfo build(Object data) {
            List objectList = (List)data;
            String libname = BuilderFactory.STRING.build(objectList.get(1));
            String engine = BuilderFactory.STRING.build(objectList.get(3));
            List rawFunctions = (List)objectList.get(5);
            List<Map<String, Object>> functions = rawFunctions.stream().map(o -> BuilderFactory.ENCODED_OBJECT_MAP.build(o)).collect(Collectors.toList());
            if (objectList.size() <= 6) {
                return new LibraryInfo(libname, engine, functions);
            }
            String code = BuilderFactory.STRING.build(objectList.get(7));
            return new LibraryInfo(libname, engine, functions, code);
        }
    };

    public LibraryInfo(String libraryName, String engineName, List<Map<String, Object>> functions) {
        this(libraryName, engineName, functions, null);
    }

    public LibraryInfo(String libraryName, String engineName, List<Map<String, Object>> functions, String code) {
        this.libraryName = libraryName;
        this.engine = engineName;
        this.functions = functions;
        this.libraryCode = code;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public String getEngine() {
        return this.engine;
    }

    public List<Map<String, Object>> getFunctions() {
        return this.functions;
    }

    public String getLibraryCode() {
        return this.libraryCode;
    }
}

