/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.util.SafeEncoder;

public class XTrimParams
implements IParams {
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private String minId;
    private Long limit;

    public static XTrimParams xTrimParams() {
        return new XTrimParams();
    }

    public XTrimParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XTrimParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XTrimParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XTrimParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XTrimParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.maxLen != null) {
            args.add(Protocol.Keyword.MAXLEN.getRaw());
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(Protocol.toByteArray(this.maxLen));
        } else if (this.minId != null) {
            args.add(Protocol.Keyword.MINID.getRaw());
            if (this.approximateTrimming) {
                args.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args.add(Protocol.BYTES_EQUAL);
            }
            args.add(SafeEncoder.encode(this.minId));
        }
        if (this.limit != null) {
            args.add(Protocol.Keyword.LIMIT.getRaw());
            args.add(Protocol.toByteArray(this.limit));
        }
    }
}

