/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;

public class GeoRadiusParam
implements IParams {
    private boolean withCoord = false;
    private boolean withDist = false;
    private boolean withHash = false;
    private Integer count = null;
    private boolean any = false;
    private boolean asc = false;
    private boolean desc = false;

    public static GeoRadiusParam geoRadiusParam() {
        return new GeoRadiusParam();
    }

    public GeoRadiusParam withCoord() {
        this.withCoord = true;
        return this;
    }

    public GeoRadiusParam withDist() {
        this.withDist = true;
        return this;
    }

    public GeoRadiusParam withHash() {
        this.withHash = true;
        return this;
    }

    public GeoRadiusParam sortAscending() {
        this.asc = true;
        return this;
    }

    public GeoRadiusParam sortDescending() {
        this.desc = true;
        return this;
    }

    public GeoRadiusParam count(int count) {
        if (count > 0) {
            this.count = count;
        }
        return this;
    }

    public GeoRadiusParam count(int count, boolean any) {
        if (count > 0) {
            this.count = count;
            if (any) {
                this.any = true;
            }
        }
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        if (this.withCoord) {
            args.add(Protocol.Keyword.WITHCOORD);
        }
        if (this.withDist) {
            args.add(Protocol.Keyword.WITHDIST);
        }
        if (this.withHash) {
            args.add(Protocol.Keyword.WITHHASH);
        }
        if (this.count != null) {
            args.add(Protocol.Keyword.COUNT).add(this.count);
            if (this.any) {
                args.add(Protocol.Keyword.ANY);
            }
        }
        if (this.asc) {
            args.add(Protocol.Keyword.ASC);
        } else if (this.desc) {
            args.add(Protocol.Keyword.DESC);
        }
    }
}

