/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jpa.provider.ds.openjpa;

import java.util.List;
import org.apache.aries.jpa.template.JpaTemplate;
import org.apache.aries.jpa.template.TransactionType;
import org.apache.karaf.examples.jpa.Booking;
import org.apache.karaf.examples.jpa.BookingService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BookingService.class}, immediate=true)
public class BookingServiceImpl
implements BookingService {
    @Reference(target="(osgi.unit.name=booking-openjpa)")
    private JpaTemplate jpaTemplate;

    public void add(Booking booking) {
        this.jpaTemplate.tx(TransactionType.RequiresNew, entityManager -> {
            entityManager.persist((Object)booking);
            entityManager.flush();
        });
    }

    public void add(String flight, String customer) {
        Booking booking = new Booking();
        booking.setCustomer(customer);
        booking.setFlight(flight);
        this.jpaTemplate.tx(TransactionType.RequiresNew, entityManager -> {
            entityManager.persist((Object)booking);
            entityManager.flush();
        });
    }

    public List<Booking> list() {
        return (List)this.jpaTemplate.txExpr(TransactionType.Supports, entityManager -> entityManager.createQuery("SELECT b FROM Booking b", Booking.class).getResultList());
    }

    public Booking get(Long id) {
        return (Booking)this.jpaTemplate.txExpr(TransactionType.Supports, entityManager -> (Booking)entityManager.find(Booking.class, (Object)id));
    }

    public void remove(Long id) {
        this.jpaTemplate.tx(TransactionType.RequiresNew, entityManager -> {
            Booking booking = (Booking)entityManager.find(Booking.class, (Object)id);
            if (booking != null) {
                entityManager.remove((Object)booking);
            }
        });
    }
}

