/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jpa.provider.blueprint.eclipselink;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.transaction.Transactional;
import org.apache.karaf.examples.jpa.Booking;
import org.apache.karaf.examples.jpa.BookingService;

@Transactional
public class BookingServiceImpl
implements BookingService {
    @PersistenceContext(unitName="booking-eclipselink")
    private EntityManager entityManager;

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void add(Booking booking) {
        this.entityManager.persist((Object)booking);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void add(String flight, String customer) {
        Booking booking = new Booking();
        booking.setCustomer(customer);
        booking.setFlight(flight);
        this.entityManager.persist((Object)booking);
    }

    @Transactional(value=Transactional.TxType.SUPPORTS)
    public List<Booking> list() {
        TypedQuery query = this.entityManager.createQuery("SELECT b FROM Booking b", Booking.class);
        return query.getResultList();
    }

    @Transactional(value=Transactional.TxType.SUPPORTS)
    public Booking get(Long id) {
        TypedQuery query = this.entityManager.createQuery("SELECT b FROM Booking b WHERE b.id=:id", Booking.class);
        query.setParameter("id", (Object)id);
        Booking booking = null;
        try {
            booking = (Booking)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return booking;
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void remove(Long id) {
        Booking booking = this.get(id);
        this.entityManager.remove((Object)booking);
    }
}

