/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.jpa.command;

import org.apache.karaf.examples.jpa.Booking;
import org.apache.karaf.examples.jpa.BookingService;
import org.apache.karaf.examples.jpa.completers.BookingIdCompleter;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.table.ShellTable;

@Service
@Command(scope="booking", name="get", description="Get the booking by id")
public class GetCommand
implements Action {
    @Reference
    private BookingService bookingService;
    @Argument(index=0, name="id", description="Id of booking to retreive", required=true, multiValued=false)
    @Completion(value=BookingIdCompleter.class)
    Long id;

    public Object execute() throws Exception {
        ShellTable table = new ShellTable();
        table.column("ID");
        table.column("Flight");
        table.column("Customer");
        Booking booking = this.bookingService.get(this.id);
        table.addRow().addContent(new Object[]{booking.getId(), booking.getFlight(), booking.getCustomer()});
        table.print(System.out);
        return null;
    }
}

