/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.examples.graphql.websocket;

import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.schema.GraphQLSchema;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebServlet;
import org.apache.karaf.examples.graphql.api.GraphQLSchemaProvider;
import org.apache.karaf.examples.graphql.websocket.GraphQLWebSocketExample;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@WebServlet(name="Example GraphQL WebSocket Servlet", urlPatterns={"/graphql-websocket"})
@Component(service={Servlet.class}, property={"osgi.http.whiteboard.servlet.pattern=/graphql-websocket"})
public class GraphQLWebSocketServlet
extends WebSocketServlet
implements WebSocketCreator {
    @Reference(service=GraphQLSchemaProvider.class)
    private GraphQLSchemaProvider schemaProvider;

    public Object createWebSocket(ServletUpgradeRequest servletUpgradeRequest, ServletUpgradeResponse servletUpgradeResponse) {
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schemaProvider.createSchema()).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy()).build();
        return new GraphQLWebSocketExample(graphQL);
    }

    public void configure(WebSocketServletFactory factory) {
        factory.setCreator((WebSocketCreator)this);
    }
}

