/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state;

import java.time.Duration;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueBytesStoreSupplier;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.Stores;
import org.apache.kafka.streams.state.TimestampedBytesStore;
import org.apache.kafka.streams.state.TimestampedKeyValueStore;
import org.apache.kafka.streams.state.TimestampedWindowStore;
import org.apache.kafka.streams.state.WindowBytesStoreSupplier;
import org.apache.kafka.streams.state.WindowStore;
import org.apache.kafka.streams.state.internals.InMemoryKeyValueStore;
import org.apache.kafka.streams.state.internals.MemoryNavigableLRUCache;
import org.apache.kafka.streams.state.internals.RocksDBSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBSessionStore;
import org.apache.kafka.streams.state.internals.RocksDBStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedSegmentedBytesStore;
import org.apache.kafka.streams.state.internals.RocksDBTimestampedStore;
import org.apache.kafka.streams.state.internals.RocksDBWindowStore;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Test;

public class StoresTest {
    @Test
    public void shouldThrowIfPersistentKeyValueStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.persistentKeyValueStore(null));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfPersistentTimestampedKeyValueStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.persistentTimestampedKeyValueStore(null));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIMemoryKeyValueStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.inMemoryKeyValueStore(null));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfILruMapStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.lruMap(null, (int)0));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfILruMapStoreCapacityIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.lruMap((String)"anyName", (int)-1));
        Assert.assertEquals((Object)"maxCacheSize cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentWindowStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.persistentWindowStore(null, (Duration)Duration.ZERO, (Duration)Duration.ZERO, (boolean)false));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentTimestampedWindowStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.persistentTimestampedWindowStore(null, (Duration)Duration.ZERO, (Duration)Duration.ZERO, (boolean)false));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentWindowStoreRetentionPeriodIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.persistentWindowStore((String)"anyName", (Duration)Duration.ofMillis(-1L), (Duration)Duration.ZERO, (boolean)false));
        Assert.assertEquals((Object)"retentionPeriod cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentTimestampedWindowStoreRetentionPeriodIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.persistentTimestampedWindowStore((String)"anyName", (Duration)Duration.ofMillis(-1L), (Duration)Duration.ZERO, (boolean)false));
        Assert.assertEquals((Object)"retentionPeriod cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentWindowStoreIfWindowSizeIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.persistentWindowStore((String)"anyName", (Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(-1L), (boolean)false));
        Assert.assertEquals((Object)"windowSize cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentTimestampedWindowStoreIfWindowSizeIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.persistentTimestampedWindowStore((String)"anyName", (Duration)Duration.ofMillis(0L), (Duration)Duration.ofMillis(-1L), (boolean)false));
        Assert.assertEquals((Object)"windowSize cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentSessionStoreStoreNameIsNull() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.persistentSessionStore(null, (Duration)Duration.ofMillis(0L)));
        Assert.assertEquals((Object)"name cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfIPersistentSessionStoreRetentionPeriodIsNegative() {
        Exception e = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> Stores.persistentSessionStore((String)"anyName", (Duration)Duration.ofMillis(-1L)));
        Assert.assertEquals((Object)"retentionPeriod cannot be negative", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfSupplierIsNullForWindowStoreBuilder() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.windowStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray()));
        Assert.assertEquals((Object)"supplier cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfSupplierIsNullForKeyValueStoreBuilder() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.keyValueStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray()));
        Assert.assertEquals((Object)"supplier cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldThrowIfSupplierIsNullForSessionStoreBuilder() {
        Exception e = (Exception)Assert.assertThrows(NullPointerException.class, () -> Stores.sessionStoreBuilder(null, (Serde)Serdes.ByteArray(), (Serde)Serdes.ByteArray()));
        Assert.assertEquals((Object)"supplier cannot be null", (Object)e.getMessage());
    }

    @Test
    public void shouldCreateInMemoryKeyValueStore() {
        MatcherAssert.assertThat((Object)Stores.inMemoryKeyValueStore((String)"memory").get(), (Matcher)IsInstanceOf.instanceOf(InMemoryKeyValueStore.class));
    }

    @Test
    public void shouldCreateMemoryNavigableCache() {
        MatcherAssert.assertThat((Object)Stores.lruMap((String)"map", (int)10).get(), (Matcher)IsInstanceOf.instanceOf(MemoryNavigableLRUCache.class));
    }

    @Test
    public void shouldCreateRocksDbStore() {
        MatcherAssert.assertThat((Object)Stores.persistentKeyValueStore((String)"store").get(), (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{IsNot.not((Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedStore.class)), IsInstanceOf.instanceOf(RocksDBStore.class)}));
    }

    @Test
    public void shouldCreateRocksDbTimestampedStore() {
        MatcherAssert.assertThat((Object)Stores.persistentTimestampedKeyValueStore((String)"store").get(), (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedStore.class));
    }

    @Test
    public void shouldCreateRocksDbWindowStore() {
        WindowStore store = (WindowStore)Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)false).get();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(RocksDBWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)CoreMatchers.allOf((Matcher[])new Matcher[]{IsNot.not((Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedSegmentedBytesStore.class)), IsInstanceOf.instanceOf(RocksDBSegmentedBytesStore.class)}));
    }

    @Test
    public void shouldCreateRocksDbTimestampedWindowStore() {
        WindowStore store = (WindowStore)Stores.persistentTimestampedWindowStore((String)"store", (Duration)Duration.ofMillis(1L), (Duration)Duration.ofMillis(1L), (boolean)false).get();
        StateStore wrapped = ((WrappedStateStore)store).wrapped();
        MatcherAssert.assertThat((Object)store, (Matcher)IsInstanceOf.instanceOf(RocksDBWindowStore.class));
        MatcherAssert.assertThat((Object)wrapped, (Matcher)IsInstanceOf.instanceOf(RocksDBTimestampedSegmentedBytesStore.class));
    }

    @Test
    public void shouldCreateRocksDbSessionStore() {
        MatcherAssert.assertThat((Object)Stores.persistentSessionStore((String)"store", (Duration)Duration.ofMillis(1L)).get(), (Matcher)IsInstanceOf.instanceOf(RocksDBSessionStore.class));
    }

    @Test
    public void shouldBuildKeyValueStore() {
        KeyValueStore store = (KeyValueStore)Stores.keyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"name"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedKeyValueStore() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentTimestampedKeyValueStore((String)"name"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedKeyValueStoreThatWrapsKeyValueStore() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.persistentKeyValueStore((String)"name"), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedKeyValueStoreThatWrapsInMemoryKeyValueStore() {
        TimestampedKeyValueStore store = (TimestampedKeyValueStore)Stores.timestampedKeyValueStoreBuilder((KeyValueBytesStoreSupplier)Stores.inMemoryKeyValueStore((String)"name"), (Serde)Serdes.String(), (Serde)Serdes.String()).withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(TimestampedBytesStore.class));
    }

    @Test
    public void shouldBuildWindowStore() {
        WindowStore store = (WindowStore)Stores.windowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L), (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedWindowStore() {
        TimestampedWindowStore store = (TimestampedWindowStore)Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentTimestampedWindowStore((String)"store", (Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L), (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedWindowStoreThatWrapsWindowStore() {
        TimestampedWindowStore store = (TimestampedWindowStore)Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.persistentWindowStore((String)"store", (Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L), (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldBuildTimestampedWindowStoreThatWrapsInMemoryWindowStore() {
        TimestampedWindowStore store = (TimestampedWindowStore)Stores.timestampedWindowStoreBuilder((WindowBytesStoreSupplier)Stores.inMemoryWindowStore((String)"store", (Duration)Duration.ofMillis(3L), (Duration)Duration.ofMillis(3L), (boolean)true), (Serde)Serdes.String(), (Serde)Serdes.String()).withLoggingDisabled().withCachingDisabled().build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)((WrappedStateStore)store).wrapped(), (Matcher)IsInstanceOf.instanceOf(TimestampedBytesStore.class));
    }

    @Test
    public void shouldBuildSessionStore() {
        SessionStore store = (SessionStore)Stores.sessionStoreBuilder((SessionBytesStoreSupplier)Stores.persistentSessionStore((String)"name", (Duration)Duration.ofMillis(10L)), (Serde)Serdes.String(), (Serde)Serdes.String()).build();
        MatcherAssert.assertThat((Object)store, (Matcher)IsNot.not((Matcher)CoreMatchers.nullValue()));
    }
}

