/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals.assignment;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.internals.assignment.ConsumerProtocolUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacySubscriptionInfoSerde {
    private static final Logger log = LoggerFactory.getLogger(LegacySubscriptionInfoSerde.class);
    static final int UNKNOWN = -1;
    private final int usedVersion;
    private final int latestSupportedVersion;
    private final UUID processId;
    private final Set<TaskId> prevTasks;
    private final Set<TaskId> standbyTasks;
    private final String userEndPoint;

    public LegacySubscriptionInfoSerde(int version, int latestSupportedVersion, UUID processId, Set<TaskId> prevTasks, Set<TaskId> standbyTasks, String userEndPoint) {
        if (latestSupportedVersion == -1 && (version < 1 || version > 2)) {
            throw new IllegalArgumentException("Only versions 1 and 2 are expected to use an UNKNOWN (-1) latest supported version. Got " + version + ".");
        }
        if (latestSupportedVersion != -1 && (version < 1 || version > latestSupportedVersion)) {
            throw new IllegalArgumentException("version must be between 1 and " + latestSupportedVersion + "; was: " + version);
        }
        this.usedVersion = version;
        this.latestSupportedVersion = latestSupportedVersion;
        this.processId = processId;
        this.prevTasks = prevTasks;
        this.standbyTasks = standbyTasks;
        this.userEndPoint = userEndPoint == null || userEndPoint.isEmpty() ? null : userEndPoint;
    }

    public int version() {
        return this.usedVersion;
    }

    public int latestSupportedVersion() {
        return this.latestSupportedVersion;
    }

    public UUID processId() {
        return this.processId;
    }

    public Set<TaskId> prevTasks() {
        return this.prevTasks;
    }

    public Set<TaskId> standbyTasks() {
        return this.standbyTasks;
    }

    public String userEndPoint() {
        return this.userEndPoint;
    }

    public ByteBuffer encode() {
        if (this.usedVersion == 3 || this.usedVersion == 4 || this.usedVersion == 5 || this.usedVersion == 6) {
            byte[] endPointBytes = LegacySubscriptionInfoSerde.prepareUserEndPoint(this.userEndPoint);
            ByteBuffer buf = ByteBuffer.allocate(28 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8 + 4 + endPointBytes.length);
            buf.putInt(this.usedVersion);
            buf.putInt(11);
            LegacySubscriptionInfoSerde.encodeClientUUID(buf, this.processId());
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.prevTasks, this.usedVersion);
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.standbyTasks, this.usedVersion);
            LegacySubscriptionInfoSerde.encodeUserEndPoint(buf, endPointBytes);
            buf.rewind();
            return buf;
        }
        if (this.usedVersion == 2) {
            byte[] endPointBytes = LegacySubscriptionInfoSerde.prepareUserEndPoint(this.userEndPoint);
            ByteBuffer buf = ByteBuffer.allocate(24 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8 + 4 + endPointBytes.length);
            buf.putInt(2);
            LegacySubscriptionInfoSerde.encodeClientUUID(buf, this.processId());
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.prevTasks, this.usedVersion);
            LegacySubscriptionInfoSerde.encodeTasks(buf, this.standbyTasks, this.usedVersion);
            LegacySubscriptionInfoSerde.encodeUserEndPoint(buf, endPointBytes);
            buf.rewind();
            return buf;
        }
        if (this.usedVersion == 1) {
            ByteBuffer buf1 = ByteBuffer.allocate(24 + this.prevTasks.size() * 8 + 4 + this.standbyTasks.size() * 8);
            buf1.putInt(1);
            LegacySubscriptionInfoSerde.encodeClientUUID(buf1, this.processId());
            LegacySubscriptionInfoSerde.encodeTasks(buf1, this.prevTasks, this.usedVersion);
            LegacySubscriptionInfoSerde.encodeTasks(buf1, this.standbyTasks, this.usedVersion);
            buf1.rewind();
            return buf1;
        }
        throw new IllegalStateException("Unknown metadata version: " + this.usedVersion + "; latest supported version: " + 11);
    }

    public static void encodeClientUUID(ByteBuffer buf, UUID processId) {
        buf.putLong(processId.getMostSignificantBits());
        buf.putLong(processId.getLeastSignificantBits());
    }

    public static void encodeTasks(ByteBuffer buf, Collection<TaskId> taskIds, int version) {
        buf.putInt(taskIds.size());
        for (TaskId id : taskIds) {
            ConsumerProtocolUtils.writeTaskIdTo((TaskId)id, (ByteBuffer)buf, (int)version);
        }
    }

    public static void encodeUserEndPoint(ByteBuffer buf, byte[] endPointBytes) {
        if (endPointBytes != null) {
            buf.putInt(endPointBytes.length);
            buf.put(endPointBytes);
        }
    }

    public static byte[] prepareUserEndPoint(String userEndPoint) {
        if (userEndPoint == null) {
            return new byte[0];
        }
        return userEndPoint.getBytes(StandardCharsets.UTF_8);
    }

    public static LegacySubscriptionInfoSerde decode(ByteBuffer data) {
        data.rewind();
        int usedVersion = data.getInt();
        if (usedVersion > 2 && usedVersion < 7) {
            int latestSupportedVersion = data.getInt();
            UUID processId = LegacySubscriptionInfoSerde.decodeProcessId(data);
            Set<TaskId> prevTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            Set<TaskId> standbyTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            String userEndPoint = LegacySubscriptionInfoSerde.decodeUserEndpoint(data);
            return new LegacySubscriptionInfoSerde(usedVersion, latestSupportedVersion, processId, prevTasks, standbyTasks, userEndPoint);
        }
        if (usedVersion == 2) {
            UUID processId = LegacySubscriptionInfoSerde.decodeProcessId(data);
            Set<TaskId> prevTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            Set<TaskId> standbyTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            String userEndPoint = LegacySubscriptionInfoSerde.decodeUserEndpoint(data);
            return new LegacySubscriptionInfoSerde(2, -1, processId, prevTasks, standbyTasks, userEndPoint);
        }
        if (usedVersion == 1) {
            UUID processId = LegacySubscriptionInfoSerde.decodeProcessId(data);
            Set<TaskId> prevTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            Set<TaskId> standbyTasks = LegacySubscriptionInfoSerde.decodeTasks(data, usedVersion);
            return new LegacySubscriptionInfoSerde(1, -1, processId, prevTasks, standbyTasks, null);
        }
        int latestSupportedVersion = data.getInt();
        log.info("Unable to decode subscription data: used version: {}; latest supported version: {}", (Object)usedVersion, (Object)11);
        return new LegacySubscriptionInfoSerde(usedVersion, latestSupportedVersion, null, null, null, null);
    }

    private static String decodeUserEndpoint(ByteBuffer data) {
        int userEndpointBytesLength = data.getInt();
        byte[] userEndpointBytes = new byte[userEndpointBytesLength];
        data.get(userEndpointBytes);
        return new String(userEndpointBytes, StandardCharsets.UTF_8);
    }

    private static Set<TaskId> decodeTasks(ByteBuffer data, int version) {
        HashSet<TaskId> prevTasks = new HashSet<TaskId>();
        int numPrevTasks = data.getInt();
        for (int i = 0; i < numPrevTasks; ++i) {
            prevTasks.add(ConsumerProtocolUtils.readTaskIdFrom((ByteBuffer)data, (int)version));
        }
        return prevTasks;
    }

    private static UUID decodeProcessId(ByteBuffer data) {
        return new UUID(data.getLong(), data.getLong());
    }

    public int hashCode() {
        int hashCode = this.usedVersion ^ this.latestSupportedVersion ^ this.processId.hashCode() ^ this.prevTasks.hashCode() ^ this.standbyTasks.hashCode();
        if (this.userEndPoint == null) {
            return hashCode;
        }
        return hashCode ^ this.userEndPoint.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LegacySubscriptionInfoSerde) {
            LegacySubscriptionInfoSerde other = (LegacySubscriptionInfoSerde)o;
            return this.usedVersion == other.usedVersion && this.latestSupportedVersion == other.latestSupportedVersion && this.processId.equals(other.processId) && this.prevTasks.equals(other.prevTasks) && this.standbyTasks.equals(other.standbyTasks) && this.userEndPoint != null ? this.userEndPoint.equals(other.userEndPoint) : other.userEndPoint == null;
        }
        return false;
    }

    public String toString() {
        return "[version=" + this.usedVersion + ", supported version=" + this.latestSupportedVersion + ", process ID=" + this.processId + ", prev tasks=" + this.prevTasks + ", standby tasks=" + this.standbyTasks + ", user endpoint=" + this.userEndPoint + "]";
    }
}

